/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_4;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class PhysicalLogCommandReaderV2_2_4Test {
    @Test
    public void shouldReadNoKeyIdAsMinusOne() throws Exception {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        IndexDefineCommand definitions = new IndexDefineCommand();
        int indexNameId = 10;
        definitions.init(MapUtil.genericMap((Object[])new Object[]{"myindex", indexNameId}), MapUtil.genericMap((Object[])new Object[0]));
        definitions.serialize((WritableChannel)channel);
        IndexCommand.RemoveCommand removeCommand = new IndexCommand.RemoveCommand();
        removeCommand.init(indexNameId, IndexEntityType.Node.id(), 1234L, -1, null);
        removeCommand.serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV2_2_4 reader = new PhysicalLogCommandReaderV2_2_4();
        Assert.assertTrue((boolean)(reader.read((ReadableChannel)channel) instanceof IndexDefineCommand));
        IndexCommand.RemoveCommand readRemoveCommand = (IndexCommand.RemoveCommand)reader.read((ReadableChannel)channel);
        Assert.assertEquals((long)removeCommand.getIndexNameId(), (long)readRemoveCommand.getIndexNameId());
        Assert.assertEquals((long)removeCommand.getEntityType(), (long)readRemoveCommand.getEntityType());
        Assert.assertEquals((long)removeCommand.getEntityId(), (long)readRemoveCommand.getEntityId());
        Assert.assertEquals((long)removeCommand.getKeyId(), (long)readRemoveCommand.getKeyId());
        Assert.assertNull((Object)removeCommand.getValue());
    }
}

