/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.ArrayIOCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionLogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;

public class TransactionLogEntryCursorTest {
    @Test
    public void shouldDeliverIntactTransactions() throws IOException {
        List<LogEntry> tx1 = this.makeTransaction(1, 3, 5);
        List<LogEntry> tx2 = this.makeTransaction(1, 3, 3, 5);
        TransactionLogEntryCursor transactionCursor = new TransactionLogEntryCursor(new ArrayIOCursor<LogEntry>(this.transactionsAsArray(tx1, tx2)));
        Assert.assertTrue((boolean)transactionCursor.next());
        this.assertTx(tx1, transactionCursor.get());
        Assert.assertTrue((boolean)transactionCursor.next());
        this.assertTx(tx2, transactionCursor.get());
        TestCase.assertFalse((boolean)transactionCursor.next());
    }

    @Test
    public void shouldNotDeliverTransactionsWithoutEnd() throws IOException {
        List<LogEntry> tx1 = this.makeTransaction(1, 3, 3, 3, 5);
        List<LogEntry> tx2 = this.makeTransaction(1, 3, 3);
        TransactionLogEntryCursor transactionCursor = new TransactionLogEntryCursor(new ArrayIOCursor<LogEntry>(this.transactionsAsArray(tx1, tx2)));
        Assert.assertTrue((boolean)transactionCursor.next());
        this.assertTx(tx1, transactionCursor.get());
        TestCase.assertFalse((boolean)transactionCursor.next());
    }

    private LogEntry[] transactionsAsArray(List<LogEntry> ... transactions) {
        ArrayList<LogEntry> allTransactions = new ArrayList<LogEntry>();
        for (List<LogEntry> tx : transactions) {
            allTransactions.addAll(tx);
        }
        return allTransactions.toArray(new LogEntry[allTransactions.size()]);
    }

    private void assertTx(List<LogEntry> expected, LogEntry[] actual) {
        Assert.assertArrayEquals((Object[])expected.toArray(new LogEntry[expected.size()]), (Object[])actual);
    }

    private List<LogEntry> makeTransaction(byte ... types) {
        ArrayList<LogEntry> transaction = new ArrayList<LogEntry>(types.length);
        byte[] byArray = types;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte type = byArray[i];
            transaction.add(this.mockedLogEntry(type));
        }
        return transaction;
    }

    private LogEntry mockedLogEntry(byte type) {
        LogEntry logEntry = (LogEntry)Mockito.mock(LogEntry.class);
        Mockito.when((Object)logEntry.getType()).thenReturn((Object)type);
        return logEntry;
    }
}

