/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;

public class LogHeaderWriterTest {
    private final long expectedLogVersion = 6L;
    private final long expectedTxId = 42L;

    @Test
    public void shouldWriteALogHeaderInTheGivenChannel() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        LogHeaderWriter.writeLogHeader((FlushableChannel)channel, (long)6L, (long)42L);
        long encodedLogVersions = channel.getLong();
        Assert.assertEquals((long)LogHeaderWriter.encodeLogVersion((long)6L), (long)encodedLogVersions);
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion((long)encodedLogVersions);
        Assert.assertEquals((long)6L, (long)logFormatVersion);
        long logVersion = LogHeaderReader.decodeLogVersion((long)encodedLogVersions);
        Assert.assertEquals((long)6L, (long)logVersion);
        long txId = channel.getLong();
        Assert.assertEquals((long)42L, (long)txId);
    }

    @Test
    public void shouldWriteALogHeaderInTheGivenBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        ByteBuffer result = LogHeaderWriter.writeLogHeader((ByteBuffer)buffer, (long)6L, (long)42L);
        Assert.assertSame((Object)buffer, (Object)result);
        long encodedLogVersions = result.getLong();
        Assert.assertEquals((long)LogHeaderWriter.encodeLogVersion((long)6L), (long)encodedLogVersions);
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion((long)encodedLogVersions);
        Assert.assertEquals((long)6L, (long)logFormatVersion);
        long logVersion = LogHeaderReader.decodeLogVersion((long)encodedLogVersions);
        Assert.assertEquals((long)6L, (long)logVersion);
        long txId = result.getLong();
        Assert.assertEquals((long)42L, (long)txId);
    }

    @Test
    public void shouldWriteALogHeaderInAFile() throws IOException {
        File file = File.createTempFile("WriteLogHeader", this.getClass().getSimpleName());
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        LogHeaderWriter.writeLogHeader((FileSystemAbstraction)fs, (File)file, (long)6L, (long)42L);
        byte[] array = new byte[16];
        try (InputStream stream = fs.openAsInputStream(file);){
            int read = stream.read(array);
            Assert.assertEquals((long)16L, (long)read);
        }
        ByteBuffer result = ByteBuffer.wrap(array);
        long encodedLogVersions = result.getLong();
        Assert.assertEquals((long)LogHeaderWriter.encodeLogVersion((long)6L), (long)encodedLogVersions);
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion((long)encodedLogVersions);
        Assert.assertEquals((long)6L, (long)logFormatVersion);
        long logVersion = LogHeaderReader.decodeLogVersion((long)encodedLogVersions);
        Assert.assertEquals((long)6L, (long)logVersion);
        long txId = result.getLong();
        Assert.assertEquals((long)42L, (long)txId);
    }

    @Test
    public void shouldWriteALogHeaderInAStoreChannel() throws IOException {
        File file = File.createTempFile("WriteLogHeader", this.getClass().getSimpleName());
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        StoreChannel channel = fs.open(file, "rw");
        LogHeaderWriter.writeLogHeader((StoreChannel)channel, (long)6L, (long)42L);
        channel.close();
        byte[] array = new byte[16];
        try (InputStream stream = fs.openAsInputStream(file);){
            int read = stream.read(array);
            Assert.assertEquals((long)16L, (long)read);
        }
        ByteBuffer result = ByteBuffer.wrap(array);
        long encodedLogVersions = result.getLong();
        Assert.assertEquals((long)LogHeaderWriter.encodeLogVersion((long)6L), (long)encodedLogVersions);
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion((long)encodedLogVersions);
        Assert.assertEquals((long)6L, (long)logFormatVersion);
        long logVersion = LogHeaderReader.decodeLogVersion((long)encodedLogVersions);
        Assert.assertEquals((long)6L, (long)logVersion);
        long txId = result.getLong();
        Assert.assertEquals((long)42L, (long)txId);
    }
}

