/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class CircularGraphTest
extends TraversalTestBase {
    @Before
    public void createTheGraph() {
        this.createGraph("1 TO 2", "2 TO 3", "3 TO 1");
    }

    @Test
    public void testCircularBug() {
        long timestamp = 3L;
        try (Transaction tx = this.beginTx();){
            this.getNodeWithName("2").setProperty("timestamp", (Object)1L);
            this.getNodeWithName("3").setProperty("timestamp", (Object)2L);
            tx.success();
        }
        var4_3 = null;
        try (Transaction tx2 = this.beginTx();){
            final RelationshipType type = RelationshipType.withName((String)"TO");
            ResourceIterator nodes = this.getGraphDb().traversalDescription().depthFirst().relationships(type, Direction.OUTGOING).evaluator(new Evaluator(){

                public Evaluation evaluate(Path path) {
                    Relationship rel = path.lastRelationship();
                    boolean relIsOfType = rel != null && rel.isType(type);
                    boolean prune = relIsOfType && (Long)path.endNode().getProperty("timestamp") >= 3L;
                    return Evaluation.of((boolean)relIsOfType, (!prune ? 1 : 0) != 0);
                }
            }).traverse(this.node("1")).nodes().iterator();
            Assert.assertEquals((Object)"2", (Object)((Node)nodes.next()).getProperty("name"));
            Assert.assertEquals((Object)"3", (Object)((Node)nodes.next()).getProperty("name"));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }
}

