/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;

public class PositionToRecoverFromTest {
    private final long logVersion = 2L;
    private final LatestCheckPointFinder finder = (LatestCheckPointFinder)Mockito.mock(LatestCheckPointFinder.class);
    private final PositionToRecoverFrom.Monitor monitor = (PositionToRecoverFrom.Monitor)Mockito.mock(PositionToRecoverFrom.Monitor.class);

    @Test
    public void shouldReturnUnspecifiedIfThereIsNoNeedForRecovery() throws Throwable {
        Mockito.when((Object)this.finder.find(2L)).thenReturn((Object)new LatestCheckPointFinder.LatestCheckPoint(null, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, 2L));
        LogPosition logPosition = new PositionToRecoverFrom(this.finder, this.monitor).apply(2L);
        ((PositionToRecoverFrom.Monitor)Mockito.verify((Object)this.monitor)).noCommitsAfterLastCheckPoint(null);
        Assert.assertEquals((Object)LogPosition.UNSPECIFIED, (Object)logPosition);
    }

    @Test
    public void shouldReturnLogPositionToRecoverFromIfNeeded() throws Throwable {
        LogPosition checkPointLogPosition = new LogPosition(1L, 4242L);
        Mockito.when((Object)this.finder.find(2L)).thenReturn((Object)new LatestCheckPointFinder.LatestCheckPoint(new CheckPoint(checkPointLogPosition), true, 10L, 2L));
        LogPosition logPosition = new PositionToRecoverFrom(this.finder, this.monitor).apply(2L);
        ((PositionToRecoverFrom.Monitor)Mockito.verify((Object)this.monitor)).commitsAfterLastCheckPoint(checkPointLogPosition, 10L);
        Assert.assertEquals((Object)checkPointLogPosition, (Object)logPosition);
    }

    @Test
    public void shouldRecoverFromStartOfLogZeroIfThereAreNoCheckPointAndOldestLogIsVersionZero() throws Throwable {
        Mockito.when((Object)this.finder.find(2L)).thenReturn((Object)new LatestCheckPointFinder.LatestCheckPoint(null, true, 10L, 0L));
        LogPosition logPosition = new PositionToRecoverFrom(this.finder, this.monitor).apply(2L);
        ((PositionToRecoverFrom.Monitor)Mockito.verify((Object)this.monitor)).noCheckPointFound();
        Assert.assertEquals((Object)LogPosition.start((long)0L), (Object)logPosition);
    }

    @Test
    public void shouldFailIfThereAreNoCheckPointsAndOldestLogVersionInNotZero() throws Throwable {
        long oldestLogVersionFound = 1L;
        Mockito.when((Object)this.finder.find(2L)).thenReturn((Object)new LatestCheckPointFinder.LatestCheckPoint(null, true, 10L, oldestLogVersionFound));
        try {
            new PositionToRecoverFrom(this.finder, this.monitor).apply(2L);
        }
        catch (UnderlyingStorageException ex) {
            String expectedMessage = "No check point found in any log file from version " + oldestLogVersionFound + " to " + 2L;
            Assert.assertEquals((Object)expectedMessage, (Object)ex.getMessage());
        }
    }
}

