/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.system;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import org.neo4j.test.rule.system.SystemExitError;

public class TestSecurityManager
extends SecurityManager {
    private SecurityManager securityManager;

    public TestSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @Override
    public void checkExit(int status) {
        throw new SystemExitError(status);
    }

    public boolean getInCheck() {
        return this.managerExists() ? this.securityManager.getInCheck() : super.getInCheck();
    }

    @Override
    public Object getSecurityContext() {
        return this.managerExists() ? this.securityManager.getSecurityContext() : super.getSecurityContext();
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.managerExists()) {
            this.securityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.managerExists()) {
            this.securityManager.checkPermission(perm, context);
        } else {
            super.checkPermission(perm, context);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.managerExists()) {
            this.securityManager.checkCreateClassLoader();
        } else {
            super.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.managerExists()) {
            this.securityManager.checkAccess(t);
        } else {
            super.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.managerExists()) {
            this.securityManager.checkAccess(g);
        } else {
            super.checkAccess(g);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.managerExists()) {
            this.securityManager.checkExec(cmd);
        } else {
            super.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.managerExists()) {
            this.securityManager.checkLink(lib);
        } else {
            super.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.managerExists()) {
            this.securityManager.checkRead(fd);
        } else {
            super.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.managerExists()) {
            this.securityManager.checkRead(file);
        } else {
            super.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.managerExists()) {
            this.securityManager.checkRead(file, context);
        } else {
            super.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (this.managerExists()) {
            this.securityManager.checkWrite(fd);
        } else {
            super.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.managerExists()) {
            this.securityManager.checkWrite(file);
        } else {
            super.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.managerExists()) {
            this.securityManager.checkDelete(file);
        } else {
            super.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.managerExists()) {
            this.securityManager.checkConnect(host, port);
        } else {
            super.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.managerExists()) {
            this.securityManager.checkConnect(host, port, context);
        } else {
            super.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.managerExists()) {
            this.securityManager.checkListen(port);
        } else {
            super.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.managerExists()) {
            this.securityManager.checkAccept(host, port);
        } else {
            super.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.managerExists()) {
            this.securityManager.checkMulticast(maddr);
        } else {
            super.checkMulticast(maddr);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (this.managerExists()) {
            this.securityManager.checkMulticast(maddr, ttl);
        } else {
            super.checkMulticast(maddr, ttl);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.managerExists()) {
            this.securityManager.checkPropertiesAccess();
        } else {
            super.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.managerExists()) {
            this.securityManager.checkPropertyAccess(key);
        } else {
            super.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        return this.managerExists() ? this.securityManager.checkTopLevelWindow(window) : super.checkTopLevelWindow(window);
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.managerExists()) {
            this.securityManager.checkPrintJobAccess();
        } else {
            super.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.managerExists()) {
            this.securityManager.checkSystemClipboardAccess();
        } else {
            super.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.managerExists()) {
            this.securityManager.checkAwtEventQueueAccess();
        } else {
            super.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.managerExists()) {
            this.securityManager.checkPackageAccess(pkg);
        } else {
            super.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.managerExists()) {
            this.securityManager.checkPackageDefinition(pkg);
        } else {
            super.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.managerExists()) {
            this.securityManager.checkSetFactory();
        } else {
            super.checkSetFactory();
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (this.managerExists()) {
            this.securityManager.checkMemberAccess(clazz, which);
        } else {
            super.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.managerExists()) {
            this.securityManager.checkSecurityAccess(target);
        } else {
            super.checkSecurityAccess(target);
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.managerExists() ? this.securityManager.getThreadGroup() : super.getThreadGroup();
    }

    private boolean managerExists() {
        return this.securityManager != null;
    }
}

