/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.unsafe.impl.batchimport.AssignRelationshipIdBatchStep;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.CapturingStep;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class AssignRelationshipIdBatchStepTest {
    private final StageControl control = (StageControl)Mockito.mock(StageControl.class);
    private final org.neo4j.unsafe.impl.batchimport.Configuration config = org.neo4j.unsafe.impl.batchimport.Configuration.withBatchSize((org.neo4j.unsafe.impl.batchimport.Configuration)org.neo4j.unsafe.impl.batchimport.Configuration.DEFAULT, (int)10);

    @Test
    public void shouldAssignNewIdsToBatches() throws Exception {
        try (AssignRelationshipIdBatchStep step = new AssignRelationshipIdBatchStep(this.control, (Configuration)this.config, 100L);
             CapturingStep results = new CapturingStep(this.control, "end", (Configuration)this.config, new StatsProvider[0]);){
            step.setDownstream(results);
            step.start(1);
            results.start(1);
            Batch first = new Batch((Object[])new InputRelationship[this.config.batchSize()]);
            step.receive(0L, (Object)first);
            Batch second = new Batch((Object[])new InputRelationship[this.config.batchSize()]);
            step.receive(1L, (Object)second);
            while (results.stats().stat((Key)Keys.done_batches).asLong() < 2L) {
            }
            Assert.assertEquals((long)2L, (long)results.receivedBatches().size());
            Assert.assertEquals((long)100L, (long)first.firstRecordId);
            Assert.assertEquals((long)(100 + this.config.batchSize()), (long)second.firstRecordId);
        }
    }

    @Test
    public void shouldAvoidReservedId() throws Exception {
        try (AssignRelationshipIdBatchStep step = new AssignRelationshipIdBatchStep(this.control, (Configuration)this.config, 0xFFFFFFF0L);
             CapturingStep results = new CapturingStep(this.control, "end", (Configuration)this.config, new StatsProvider[0]);){
            step.setDownstream(results);
            step.start(1);
            results.start(1);
            Batch first = new Batch((Object[])new InputRelationship[this.config.batchSize()]);
            step.receive(0L, (Object)first);
            Batch second = new Batch((Object[])new InputRelationship[this.config.batchSize()]);
            step.receive(1L, (Object)second);
            Batch third = new Batch((Object[])new InputRelationship[this.config.batchSize()]);
            step.receive(2L, (Object)third);
            while (results.stats().stat((Key)Keys.done_batches).asLong() < 3L) {
            }
            Assert.assertEquals((long)3L, (long)results.receivedBatches().size());
            Assert.assertEquals((long)0xFFFFFFF0L, (long)first.firstRecordId);
            Assert.assertEquals((long)0x100000000L, (long)second.firstRecordId);
            Assert.assertEquals((long)(second.firstRecordId + (long)this.config.batchSize()), (long)third.firstRecordId);
        }
    }

    @Test
    public void shouldAvoidReservedIdAsFirstAssignment() throws Exception {
        try (AssignRelationshipIdBatchStep step = new AssignRelationshipIdBatchStep(this.control, (Configuration)this.config, 0xFFFFFFFAL);
             CapturingStep results = new CapturingStep(this.control, "end", (Configuration)this.config, new StatsProvider[0]);){
            step.setDownstream(results);
            step.start(1);
            results.start(1);
            Batch first = new Batch((Object[])new InputRelationship[this.config.batchSize()]);
            step.receive(0L, (Object)first);
            Batch second = new Batch((Object[])new InputRelationship[this.config.batchSize()]);
            step.receive(1L, (Object)second);
            while (results.stats().stat((Key)Keys.done_batches).asLong() < 2L) {
            }
            Assert.assertEquals((long)2L, (long)results.receivedBatches().size());
            Assert.assertEquals((long)0x100000000L, (long)first.firstRecordId);
            Assert.assertEquals((long)(first.firstRecordId + (long)this.config.batchSize()), (long)second.firstRecordId);
        }
    }
}

