/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.ReadGroupsFromCacheStep;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class ReadGroupsFromCacheStepTest {
    @Test
    public void shouldProduceCompleteBatchesPerOwner() throws Exception {
        final org.neo4j.unsafe.impl.batchimport.Configuration config = org.neo4j.unsafe.impl.batchimport.Configuration.withBatchSize((org.neo4j.unsafe.impl.batchimport.Configuration)org.neo4j.unsafe.impl.batchimport.Configuration.DEFAULT, (int)10);
        final Iterator<RelationshipGroupRecord> groups = ReadGroupsFromCacheStepTest.groups(new Group(1L, 3), new Group(2L, 3), new Group(3L, 4), new Group(4L, 2), new Group(5L, 10), new Group(6L, 35), new Group(7L, 2)).iterator();
        final AtomicInteger processCounter = new AtomicInteger();
        Stage stage = new Stage(this.getClass().getSimpleName(), (Configuration)config){
            {
                super(x0, x1);
                this.add((Step)new ReadGroupsFromCacheStep(this.control(), (Configuration)config, groups, 1));
                this.add((Step)new VerifierStep(this.control(), config, processCounter));
            }
        };
        ExecutionSupervisors.superviseDynamicExecution((Stage)stage);
        Assert.assertEquals((long)4L, (long)processCounter.get());
    }

    protected static List<RelationshipGroupRecord> groups(Group ... groups) {
        ArrayList<RelationshipGroupRecord> records = new ArrayList<RelationshipGroupRecord>();
        for (Group group : groups) {
            for (int i = 0; i < group.count; ++i) {
                RelationshipGroupRecord record = new RelationshipGroupRecord(Record.NULL_REFERENCE.longValue());
                record.setOwningNode(group.owningNode);
                record.setNext((long)(group.count - i - 1));
                records.add(record);
            }
        }
        return records;
    }

    private static class VerifierStep
    extends ProcessorStep<RelationshipGroupRecord[]> {
        private long lastBatchLastOwningNode = -1L;
        private final AtomicInteger processCounter;

        public VerifierStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, AtomicInteger processCounter) {
            super(control, "Verifier", (Configuration)config, 1, new StatsProvider[0]);
            this.processCounter = processCounter;
        }

        protected void process(RelationshipGroupRecord[] batch, BatchSender sender) throws Throwable {
            long lastOwningNode = this.lastBatchLastOwningNode;
            for (RelationshipGroupRecord record : batch) {
                Assert.assertTrue((record.getOwningNode() >= lastOwningNode ? 1 : 0) != 0);
                Assert.assertTrue((record.getOwningNode() > this.lastBatchLastOwningNode ? 1 : 0) != 0);
            }
            this.processCounter.incrementAndGet();
            if (batch.length > 0) {
                this.lastBatchLastOwningNode = batch[batch.length - 1].getOwningNode();
            }
        }
    }

    protected static class Group {
        final long owningNode;
        final int count;

        public Group(long owningNode, int count) {
            this.owningNode = owningNode;
            this.count = count;
        }
    }
}

