/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.StoreWithReservedId;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;

public class RelationshipLinkbackStageTest {
    @Test
    public void reservedIdIsSkipped() throws Exception {
        long highId = 5L;
        RelationshipStore store = StoreWithReservedId.newRelationshipStoreMock(highId);
        RelationshipLinkbackStage stage = new RelationshipLinkbackStage("Test", Configuration.DEFAULT, store, RelationshipLinkbackStageTest.newCache(), 0L, highId, false);
        ExecutionSupervisors.superviseExecution((ExecutionMonitor)ExecutionMonitors.invisible(), (Configuration)Configuration.DEFAULT, (Stage)stage);
        ((RelationshipStore)Mockito.verify((Object)store, (VerificationMode)Mockito.never())).updateRecord((AbstractBaseRecord)new RelationshipRecord(0xFFFFFFFFL));
    }

    private static NodeRelationshipCache newCache() {
        int denseNodeThreshold = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
        return new NodeRelationshipCache(NumberArrayFactory.HEAP, denseNodeThreshold);
    }
}

