/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.executor.TaskExecutionPanicException;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Deserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.DeserializerFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputGroupsDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputNodeDeserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.ParallelInputEntityDeserializer;

public class ParallelInputEntityDeserializerTest {
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldParseDataInParallel() throws Exception {
        int entities = 500;
        Data<InputNode> data = this.testData(entities);
        Configuration.Overridden config = new Configuration.Overridden(Configuration.COMMAS){

            public int bufferSize() {
                return 100;
            }
        };
        IdType idType = IdType.ACTUAL;
        Collector badCollector = (Collector)Mockito.mock(Collector.class);
        Groups groups = new Groups();
        CopyOnWriteArraySet observedProcessingThreads = new CopyOnWriteArraySet();
        int threads = 4;
        InputGroupsDeserializer.DeserializerFactory deserializerFactory = (arg_0, arg_1, arg_2, arg_3) -> ParallelInputEntityDeserializerTest.lambda$shouldParseDataInParallel$0(observedProcessingThreads, threads, (Configuration)config, groups, idType, badCollector, arg_0, arg_1, arg_2, arg_3);
        try (ParallelInputEntityDeserializer deserializer = new ParallelInputEntityDeserializer(data, DataFactories.defaultFormatNodeFileHeader(), (Configuration)config, idType, threads, threads, deserializerFactory, Validators.emptyValidator(), InputNode.class);){
            long previousLineNumber = -1L;
            long previousPosition = -1L;
            for (long i = 0L; i < (long)entities; ++i) {
                Assert.assertTrue((boolean)deserializer.hasNext());
                InputNode entity = (InputNode)deserializer.next();
                Assert.assertEquals((long)i, (long)((Long)entity.id()));
                Assert.assertEquals((Object)"name", (Object)entity.properties()[0]);
                Assert.assertTrue((boolean)entity.properties()[1].toString().startsWith(i + "-"));
                Assert.assertTrue((entity.lineNumber() > previousLineNumber ? 1 : 0) != 0);
                previousLineNumber = entity.lineNumber();
                Assert.assertTrue((entity.position() > previousPosition ? 1 : 0) != 0);
                previousPosition = entity.position();
            }
            Assert.assertFalse((boolean)deserializer.hasNext());
            Assert.assertEquals((long)threads, (long)observedProcessingThreads.size());
        }
    }

    @Test(timeout=10000L)
    public void shouldTreatExternalCloseAsPanic() throws Exception {
        int entities = 500;
        Data<InputNode> data = this.testData(entities);
        Configuration.Overridden config = new Configuration.Overridden(Configuration.COMMAS){

            public int bufferSize() {
                return 100;
            }
        };
        IdType idType = IdType.ACTUAL;
        Collector badCollector = (Collector)Mockito.mock(Collector.class);
        Groups groups = new Groups();
        InputGroupsDeserializer.DeserializerFactory deserializerFactory = DeserializerFactories.defaultNodeDeserializer((Groups)groups, (Configuration)config, (IdType)idType, (Collector)badCollector);
        try (ParallelInputEntityDeserializer deserializer = new ParallelInputEntityDeserializer(data, DataFactories.defaultFormatNodeFileHeader(), (Configuration)config, idType, 3, 3, deserializerFactory, Validators.emptyValidator(), InputNode.class);){
            deserializer.hasNext();
            deserializer.receivePanic((Throwable)new RuntimeException());
            for (int i = 0; i < 100 && deserializer.hasNext(); ++i) {
                deserializer.next();
            }
        }
        catch (TaskExecutionPanicException taskExecutionPanicException) {
            // empty catch block
        }
    }

    private Data<InputNode> testData(int entities) {
        StringBuilder string = new StringBuilder();
        string.append(":ID,name\n");
        for (int i = 0; i < entities; ++i) {
            string.append(i).append(",").append(i).append("-").append(this.random.string()).append("\n");
        }
        return this.data(string.toString());
    }

    private Data<InputNode> data(final String string) {
        return new Data<InputNode>(){

            public CharReadable stream() {
                return Readables.wrap((Reader)new StringReader(string));
            }

            public Decorator<InputNode> decorator() {
                return InputEntityDecorators.NO_NODE_DECORATOR;
            }
        };
    }

    private static /* synthetic */ InputEntityDeserializer lambda$shouldParseDataInParallel$0(Set observedProcessingThreads, int threads, Configuration config, Groups groups, IdType idType, Collector badCollector, Header header, CharSeeker chunk, Decorator decorator, Validator validator) {
        boolean allThreadsStarted;
        observedProcessingThreads.add(Thread.currentThread());
        while (!(allThreadsStarted = observedProcessingThreads.size() == threads)) {
        }
        return new InputEntityDeserializer(header, chunk, (int)config.delimiter(), (Deserialization)new InputNodeDeserialization(header, (SourceTraceability)chunk, groups, idType.idsAreExternal()), decorator, validator, badCollector);
    }
}

