/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.neo4j.time.Clocks;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;

public class ProcessorAssignmentStrategies {
    public static ExecutionMonitor eagerRandomSaturation(final int availableProcessor) {
        return new AbstractAssigner(Clocks.systemClock(), 10L, TimeUnit.SECONDS){

            public void start(StageExecution execution) {
                this.saturate(availableProcessor, execution);
                this.registerProcessorCount(execution);
            }

            private void saturate(int availableProcessor2, StageExecution execution) {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                int processors = availableProcessor2;
                for (int rounds = 0; rounds < availableProcessor2 && processors > 0; ++rounds) {
                    for (Step step : execution.steps()) {
                        int before = step.processors(0);
                        if (!((Random)random).nextBoolean() || step.processors(1) <= before || --processors != 0) continue;
                        return;
                    }
                }
            }

            public void check(StageExecution execution) {
            }
        };
    }

    public static ExecutionMonitor randomSaturationOverTime(final int availableProcessor) {
        return new AbstractAssigner(Clocks.systemClock(), 100L, TimeUnit.MILLISECONDS){
            private int processors;
            {
                super(clock, time, unit);
                this.processors = availableProcessor;
            }

            public void check(StageExecution execution) {
                this.saturate(execution);
                this.registerProcessorCount(execution);
            }

            private void saturate(StageExecution execution) {
                if (this.processors == 0) {
                    return;
                }
                ThreadLocalRandom random = ThreadLocalRandom.current();
                int maxThisCheck = ((Random)random).nextInt(this.processors - 1) + 1;
                for (Step step : execution.steps()) {
                    int before = step.processors(0);
                    if (!((Random)random).nextBoolean() || step.processors(-1) >= before) continue;
                    --this.processors;
                    if (--maxThisCheck != 0) continue;
                    return;
                }
            }
        };
    }

    private static abstract class AbstractAssigner
    extends ExecutionMonitor.Adapter {
        private final Map<String, Map<String, Integer>> processors = new HashMap<String, Map<String, Integer>>();

        protected AbstractAssigner(Clock clock, long time, TimeUnit unit) {
            super(clock, time, unit);
        }

        protected void registerProcessorCount(StageExecution execution) {
            HashMap<String, Integer> byStage = new HashMap<String, Integer>();
            this.processors.put(execution.getStageName(), byStage);
            for (Step step : execution.steps()) {
                byStage.put(step.name(), step.processors(0));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (String stage : this.processors.keySet()) {
                builder.append(stage).append(':');
                Map<String, Integer> byStage = this.processors.get(stage);
                for (String step : byStage.keySet()) {
                    builder.append(String.format("%n  %s:%d", step, byStage.get(step)));
                }
                builder.append(String.format("%n", new Object[0]));
            }
            return builder.toString();
        }
    }
}

