/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.unsafe.impl.batchimport.executor.ParkStrategy;
import org.neo4j.unsafe.impl.batchimport.staging.TicketedProcessing;

public class TicketedProcessingTest {
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule();

    @Test
    public void shouldReturnTicketsInOrder() throws Exception {
        Future<Void> assertions;
        final int items = 1000;
        ParkStrategy.Park park = new ParkStrategy.Park(2L, TimeUnit.MILLISECONDS);
        BiFunction<Integer, Void, Integer> processor = (arg_0, arg_1) -> TicketedProcessingTest.lambda$shouldReturnTicketsInOrder$0((ParkStrategy)park, arg_0, arg_1);
        int processorCount = Runtime.getRuntime().availableProcessors();
        try (final TicketedProcessing processing = new TicketedProcessing("Doubler", processorCount, processor, () -> null);){
            processing.processors(processorCount - processing.processors(0));
            assertions = this.t2.execute(new OtherThreadExecutor.WorkerCommand<Void, Void>(){

                @Override
                public Void doWork(Void state) throws Exception {
                    for (int i = 0; i < items; ++i) {
                        Integer next = (Integer)processing.next();
                        Assert.assertNotNull((Object)next);
                        Assert.assertEquals((long)(i * 2), (long)next.intValue());
                    }
                    Assert.assertNull((Object)processing.next());
                    return null;
                }
            });
            for (int i = 0; i < items; ++i) {
                processing.submit((Object)i);
            }
        }
        assertions.get();
    }

    @Test
    public void shouldNotBeAbleToSubmitTooFarAhead() throws Exception {
        try (final TicketedProcessing processing = new TicketedProcessing("Parser", 2, (job, state) -> {
            DoubleLatch.awaitLatch(job.latch);
            return Integer.parseInt(job.string);
        }, () -> null);){
            processing.processors(1);
            StringJob firstJob = new StringJob("1");
            processing.submit((Object)firstJob);
            StringJob secondJob = new StringJob("2");
            processing.submit((Object)secondJob);
            final StringJob thirdJob = new StringJob("3");
            thirdJob.latch.countDown();
            Future<Void> thirdSubmit = this.t2.execute(new OtherThreadExecutor.WorkerCommand<Void, Void>(){

                @Override
                public Void doWork(Void state) throws Exception {
                    processing.submit((Object)thirdJob);
                    return null;
                }
            });
            this.t2.get().waitUntilThreadState(Thread.State.TIMED_WAITING, Thread.State.WAITING);
            firstJob.latch.countDown();
            Assert.assertEquals((long)1L, (long)((Integer)processing.next()).intValue());
            thirdSubmit.get();
            secondJob.latch.countDown();
            Assert.assertEquals((long)2L, (long)((Integer)processing.next()).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)processing.next()).intValue());
        }
    }

    private static /* synthetic */ Integer lambda$shouldReturnTicketsInOrder$0(ParkStrategy park, Integer from, Void ignore) {
        if (ThreadLocalRandom.current().nextFloat() < 0.01f) {
            park.park(Thread.currentThread());
        }
        return from * 2;
    }

    private static class StringJob {
        final String string;
        final CountDownLatch latch = new CountDownLatch(1);

        StringJob(String string) {
            this.string = string;
        }
    }
}

