/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.time.Clocks;

public class AvailabilityGuardTest {
    private static final AvailabilityGuard.AvailabilityRequirement REQUIREMENT_1 = AvailabilityGuard.availabilityRequirement((String)"Requirement 1");
    private static final AvailabilityGuard.AvailabilityRequirement REQUIREMENT_2 = AvailabilityGuard.availabilityRequirement((String)"Requirement 2");
    private Clock clock = Clocks.systemClock();

    @Test
    public void logOnAvailabilityChange() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        Mockito.verifyZeroInteractions((Object[])new Object[]{log});
        availabilityGuard.require(REQUIREMENT_1);
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).info(Matchers.anyString());
        availabilityGuard.fulfill(REQUIREMENT_1);
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeast((int)2))).info(Matchers.anyString());
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeast((int)3))).info(Matchers.anyString());
        availabilityGuard.fulfill(REQUIREMENT_1);
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.atMost((int)3))).info(Matchers.anyString());
        availabilityGuard.fulfill(REQUIREMENT_2);
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeast((int)4))).info(Matchers.anyString());
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.atMost((int)4))).info(Matchers.anyString());
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenAwaitThenTimeoutAndReturnFalse() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        boolean result = availabilityGuard.isAvailable(1000L);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenAwaitThenActuallyWaitGivenTimeout() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        long timeout = 1000L;
        long start = this.clock.millis();
        boolean result = availabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)waitTime, (Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantOnceAndAwaitThenTimeoutAndReturnFalse() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        long start = this.clock.millis();
        long timeout = 1000L;
        availabilityGuard.fulfill(REQUIREMENT_1);
        boolean result = availabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)waitTime, (Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantEachAndAwaitThenTrue() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        availabilityGuard.fulfill(REQUIREMENT_1);
        availabilityGuard.fulfill(REQUIREMENT_2);
        Assert.assertTrue((boolean)availabilityGuard.isAvailable(1000L));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantTwiceAndDenyOnceAndAwaitThenTimeoutAndReturnFalse() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        availabilityGuard.fulfill(REQUIREMENT_1);
        availabilityGuard.fulfill(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        long start = this.clock.millis();
        long timeout = 1000L;
        boolean result = availabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)waitTime, (Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantOnceAndAwaitAndGrantAgainThenReturnTrue() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        availabilityGuard.fulfill(REQUIREMENT_2);
        Assert.assertFalse((boolean)availabilityGuard.isAvailable(100L));
        availabilityGuard.fulfill(REQUIREMENT_1);
        Assert.assertTrue((boolean)availabilityGuard.isAvailable(100L));
    }

    @Test
    public void givenAccessGuardWithConditionWhenGrantThenNotifyListeners() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        final AtomicBoolean notified = new AtomicBoolean();
        AvailabilityGuard.AvailabilityListener availabilityListener = new AvailabilityGuard.AvailabilityListener(){

            public void available() {
                notified.set(true);
            }

            public void unavailable() {
            }
        };
        availabilityGuard.addListener(availabilityListener);
        availabilityGuard.fulfill(REQUIREMENT_1);
        Assert.assertThat((Object)notified.get(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void givenAccessGuardWithConditionWhenGrantAndDenyThenNotifyListeners() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        final AtomicBoolean notified = new AtomicBoolean();
        AvailabilityGuard.AvailabilityListener availabilityListener = new AvailabilityGuard.AvailabilityListener(){

            public void available() {
            }

            public void unavailable() {
                notified.set(true);
            }
        };
        availabilityGuard.addListener(availabilityListener);
        availabilityGuard.fulfill(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_1);
        Assert.assertThat((Object)notified.get(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void givenAccessGuardWithConditionWhenShutdownThenInstantlyDenyAccess() throws Exception {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(clock, (Log)NullLog.getInstance());
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.shutdown();
        Assert.assertFalse((boolean)availabilityGuard.isAvailable(1000L));
        Mockito.verifyZeroInteractions((Object[])new Object[]{clock});
    }

    @Test
    public void shouldExplainWhoIsBlockingAccess() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(this.clock, log);
        availabilityGuard.require(REQUIREMENT_1);
        availabilityGuard.require(REQUIREMENT_2);
        Assert.assertThat((Object)availabilityGuard.describeWhoIsBlocking(), (Matcher)CoreMatchers.equalTo((Object)"2 reasons for blocking: Requirement 1, Requirement 2."));
    }

    @Test
    public void shouldExplainBlockersOnCheckAvailable() throws Exception {
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(Clocks.systemClock(), (Log)NullLog.getInstance());
        availabilityGuard.checkAvailable();
        availabilityGuard.require(REQUIREMENT_1);
        try {
            availabilityGuard.checkAvailable();
            Assert.fail((String)"Should not be available");
        }
        catch (AvailabilityGuard.UnavailableException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.containsString((String)REQUIREMENT_1.description()));
        }
    }
}

