/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.ClassGuardedAdversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.storemigration.LogFiles;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.AdversarialPageCacheGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class RecoveryIT {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void idGeneratorsRebuildAfterRecovery() throws IOException {
        GraphDatabaseService database = this.startDatabase(this.directory.graphDbDir());
        int numberOfNodes = 10;
        try (Transaction transaction = database.beginTx();){
            for (int nodeIndex = 0; nodeIndex < numberOfNodes; ++nodeIndex) {
                database.createNode();
            }
            transaction.success();
        }
        File restoreDbStoreDir = this.copyTransactionLogs();
        GraphDatabaseService recoveredDatabase = this.startDatabase(restoreDbStoreDir);
        NeoStores neoStore = ((RecordStorageEngine)((GraphDatabaseAPI)recoveredDatabase).getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        Assert.assertEquals((long)numberOfNodes, (long)neoStore.getNodeStore().getHighId());
        Assert.assertTrue((neoStore.getNodeStore().nextId() > 0L ? 1 : 0) != 0);
        database.shutdown();
        recoveredDatabase.shutdown();
    }

    @Test
    public void shouldRecoverIdsCorrectlyWhenWeCreateAndDeleteANodeInTheSameRecoveryRun() throws IOException {
        Node node;
        GraphDatabaseService database = this.startDatabase(this.directory.graphDbDir());
        Label testLabel = Label.label((String)"testLabel");
        String propertyToDelete = "propertyToDelete";
        String validPropertyName = "validProperty";
        try (Transaction transaction = database.beginTx();){
            node = database.createNode();
            node.addLabel(testLabel);
            transaction.success();
        }
        transaction = database.beginTx();
        var6_6 = null;
        try {
            node = this.findNodeByLabel(database, testLabel);
            node.setProperty("propertyToDelete", (Object)this.createLongString());
            node.setProperty("validProperty", (Object)this.createLongString());
            transaction.success();
        }
        catch (Throwable node2) {
            var6_6 = node2;
            throw node2;
        }
        finally {
            if (transaction != null) {
                if (var6_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable node2) {
                        var6_6.addSuppressed(node2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = database.beginTx();
        var6_6 = null;
        try {
            node = this.findNodeByLabel(database, testLabel);
            node.removeProperty("propertyToDelete");
            transaction.success();
        }
        catch (Throwable node3) {
            var6_6 = node3;
            throw node3;
        }
        finally {
            if (transaction != null) {
                if (var6_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable node3) {
                        var6_6.addSuppressed(node3);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        File restoreDbStoreDir = this.copyTransactionLogs();
        GraphDatabaseService recoveredDatabase = this.startDatabase(restoreDbStoreDir);
        try (Transaction ignored = recoveredDatabase.beginTx();){
            Node node4 = this.findNodeByLabel(recoveredDatabase, testLabel);
            Assert.assertFalse((boolean)node4.hasProperty("propertyToDelete"));
            Assert.assertTrue((boolean)node4.hasProperty("validProperty"));
        }
        database.shutdown();
        recoveredDatabase.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void recoveryShouldFixPartiallyAppliedSchemaIndexUpdates() {
        Label label = Label.label((String)"Foo");
        String property = "Bar";
        ClassGuardedAdversary adversary = new ClassGuardedAdversary((Adversary)new CountingAdversary(1, true), new Class[]{Command.RelationshipCommand.class});
        adversary.disable();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        File storeDir = this.directory.graphDbDir();
        GraphDatabaseService db = AdversarialPageCacheGraphDatabaseFactory.create((FileSystemAbstraction)fs, (Adversary)adversary).newEmbeddedDatabaseBuilder(storeDir).newGraphDatabase();
        try {
            Throwable throwable;
            Transaction tx;
            try (Transaction tx2 = db.beginTx();){
                db.schema().constraintFor(label).assertPropertyIsUnique(property).create();
                tx2.success();
            }
            long relationshipId = RecoveryIT.createRelationship(db);
            TransactionFailureException txFailure = null;
            try {
                tx = db.beginTx();
                throwable = null;
                try {
                    Node node = db.createNode(new Label[]{label});
                    node.setProperty(property, (Object)"B");
                    db.getRelationshipById(relationshipId).delete();
                    tx.success();
                    adversary.enable();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (TransactionFailureException e) {
                txFailure = e;
            }
            Assert.assertNotNull((Object)((Object)txFailure));
            adversary.disable();
            RecoveryIT.healthOf(db).healed();
            tx = db.beginTx();
            throwable = null;
            try {
                Assert.assertNotNull((Object)RecoveryIT.findNode(db, label, property, "B"));
                Assert.assertNotNull((Object)db.getRelationshipById(relationshipId));
                tx.success();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            RecoveryIT.healthOf(db).panic(txFailure.getCause());
            db.shutdown();
            db = this.startDatabase(storeDir);
            tx = db.beginTx();
            throwable = null;
            try {
                Assert.assertNotNull((Object)RecoveryIT.findNode(db, label, property, "B"));
                RecoveryIT.assertRelationshipNotExist(db, relationshipId);
                tx.success();
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            db.shutdown();
        }
    }

    private Node findNodeByLabel(GraphDatabaseService database, Label testLabel) {
        try (ResourceIterator nodes = database.findNodes(testLabel);){
            Node node = (Node)nodes.next();
            return node;
        }
    }

    private static Node findNode(GraphDatabaseService db, Label label, String property, String value) {
        try (ResourceIterator nodes = db.findNodes(label, property, (Object)value);){
            Node node = (Node)Iterators.single((Iterator)nodes);
            return node;
        }
    }

    private static long createRelationship(GraphDatabaseService db) {
        long relationshipId;
        try (Transaction tx = db.beginTx();){
            Node start = db.createNode(new Label[]{Label.label((String)(System.currentTimeMillis() + ""))});
            Node end = db.createNode(new Label[]{Label.label((String)(System.currentTimeMillis() + ""))});
            relationshipId = start.createRelationshipTo(end, RelationshipType.withName((String)"KNOWS")).getId();
            tx.success();
        }
        return relationshipId;
    }

    private static void assertRelationshipNotExist(GraphDatabaseService db, long id) {
        try {
            db.getRelationshipById(id);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
    }

    private static DatabaseHealth healthOf(GraphDatabaseService db) {
        DependencyResolver resolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        return (DatabaseHealth)resolver.resolveDependency(DatabaseHealth.class);
    }

    private String createLongString() {
        Object[] strings = new String[(int)ByteUnit.kibiBytes((long)2L)];
        Arrays.fill(strings, "a");
        return Arrays.toString(strings);
    }

    private GraphDatabaseService startDatabase(File storeDir) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
    }

    private File copyTransactionLogs() throws IOException {
        File restoreDbStoreDir = this.directory.directory("restore-db");
        LogFiles.move((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (File)this.directory.graphDbDir(), (File)restoreDbStoreDir);
        return restoreDbStoreDir;
    }
}

