/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.function.Supplier;
import org.mockito.Mockito;
import org.neo4j.collection.pool.Pool;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationContainer;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.time.Clocks;

public class KernelTransactionFactory {
    static Instances kernelTransactionWithInternals(SecurityContext securityContext) {
        TransactionHeaderInformation headerInformation = new TransactionHeaderInformation(-1, -1, new byte[0]);
        TransactionHeaderInformationFactory headerInformationFactory = (TransactionHeaderInformationFactory)Mockito.mock(TransactionHeaderInformationFactory.class);
        Mockito.when((Object)headerInformationFactory.create()).thenReturn((Object)headerInformation);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        Mockito.when((Object)storeReadLayer.newStatement()).thenReturn((Object)storageStatement);
        Mockito.when((Object)storageEngine.storeReadLayer()).thenReturn((Object)storeReadLayer);
        KernelTransactionImplementation transaction = new KernelTransactionImplementation((StatementOperationContainer)Mockito.mock(StatementOperationContainer.class), (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), new TransactionHooks(), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), new Procedures(), headerInformationFactory, (TransactionCommitProcess)Mockito.mock(TransactionRepresentationCommitProcess.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), (Supplier)Mockito.mock(Supplier.class), (Pool)Mockito.mock(Pool.class), Clocks.systemClock(), TransactionTracer.NULL, storageEngine, (AccessCapability)new CanWrite());
        SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
        transaction.initialize(0L, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, securityContext, 0L);
        return new Instances(transaction, storageEngine, storeReadLayer, storageStatement);
    }

    static KernelTransaction kernelTransaction(SecurityContext securityContext) {
        return KernelTransactionFactory.kernelTransactionWithInternals((SecurityContext)securityContext).transaction;
    }

    public static class Instances {
        public KernelTransactionImplementation transaction;
        public StorageEngine storageEngine;
        public StoreReadLayer storeReadLayer;
        public StorageStatement storageStatement;

        public Instances(KernelTransactionImplementation transaction, StorageEngine storageEngine, StoreReadLayer storeReadLayer, StorageStatement storageStatement) {
            this.transaction = transaction;
            this.storageEngine = storageEngine;
            this.storeReadLayer = storeReadLayer;
            this.storageStatement = storageStatement;
        }
    }
}

