/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txtracking;

import java.time.Duration;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.txtracking.TransactionIdTracker;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class TransactionIdTrackerTest {
    private final Supplier<TransactionIdStore> transactionIdStoreSupplier = (Supplier)Mockito.mock(Supplier.class);
    private final AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);

    @Test(timeout=500L)
    public void shouldAlwaysReturnIfTheRequestVersionIsBaseTxIdOrLess() throws Exception {
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)this.transactionIdStoreSupplier.get()).thenReturn((Object)transactionIdStore);
        Mockito.when((Object)transactionIdStore.getLastClosedTransactionId()).thenReturn((Object)-1L);
        Mockito.when((Object)this.availabilityGuard.isAvailable()).thenReturn((Object)true);
        TransactionIdTracker transactionIdTracker = new TransactionIdTracker(this.transactionIdStoreSupplier, this.availabilityGuard);
        transactionIdTracker.awaitUpToDate(1L, Duration.ofSeconds(5L));
    }

    @Test(timeout=500L)
    public void shouldReturnIfTheVersionIsUpToDate() throws Exception {
        long version = 5L;
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)this.transactionIdStoreSupplier.get()).thenReturn((Object)transactionIdStore);
        Mockito.when((Object)transactionIdStore.getLastClosedTransactionId()).thenReturn((Object)version);
        Mockito.when((Object)this.availabilityGuard.isAvailable()).thenReturn((Object)true);
        TransactionIdTracker transactionIdTracker = new TransactionIdTracker(this.transactionIdStoreSupplier, this.availabilityGuard);
        transactionIdTracker.awaitUpToDate(version, Duration.ofSeconds(5L));
    }

    @Test(timeout=500L)
    public void shouldTimeoutIfTheVersionIsTooHigh() throws Exception {
        long version = 5L;
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)this.transactionIdStoreSupplier.get()).thenReturn((Object)transactionIdStore);
        Mockito.when((Object)transactionIdStore.getLastClosedTransactionId()).thenReturn((Object)version);
        Mockito.when((Object)this.availabilityGuard.isAvailable()).thenReturn((Object)true);
        TransactionIdTracker transactionIdTracker = new TransactionIdTracker(this.transactionIdStoreSupplier, this.availabilityGuard);
        try {
            transactionIdTracker.awaitUpToDate(version + 1L, Duration.ofMillis(50L));
            Assert.fail((String)"should have thrown");
        }
        catch (TransactionFailureException ex) {
            Assert.assertEquals((Object)Status.Transaction.InstanceStateChanged, (Object)ex.status());
        }
    }

    @Test(timeout=500L)
    public void shouldGiveUpWaitingIfTheDatabaseIsUnavailable() throws Exception {
        long version = 5L;
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)this.transactionIdStoreSupplier.get()).thenReturn((Object)transactionIdStore);
        Mockito.when((Object)transactionIdStore.getLastClosedTransactionId()).thenReturn((Object)version);
        Mockito.when((Object)this.availabilityGuard.isAvailable()).thenReturn((Object)false);
        TransactionIdTracker transactionIdTracker = new TransactionIdTracker(this.transactionIdStoreSupplier, this.availabilityGuard);
        try {
            transactionIdTracker.awaitUpToDate(version + 1L, Duration.ofMillis(60000L));
            Assert.fail((String)"should have thrown");
        }
        catch (TransactionFailureException ex) {
            Assert.assertEquals((Object)Status.General.DatabaseUnavailable, (Object)ex.status());
        }
    }
}

