/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexSchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.builtinprocs.IndexProcedures;
import org.neo4j.kernel.builtinprocs.StubKernelTransaction;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;

public class ResampleIndexProcedureTest {
    private final ReadOperations operations = (ReadOperations)Mockito.mock(ReadOperations.class);
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final IndexProcedures procedure = new IndexProcedures((KernelTransaction)new StubKernelTransaction(this.operations), this.indexingService);

    @Test
    public void shouldThrowAnExceptionIfTheLabelDoesntExist() throws ProcedureException {
        Mockito.when((Object)this.operations.labelGetForName("NonExistentLabel")).thenReturn((Object)-1);
        try {
            this.procedure.resampleIndex(":NonExistentLabel(prop)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)org.hamcrest.Matchers.is((Object)Status.Schema.LabelAccessFailed));
        }
    }

    @Test
    public void shouldThrowAnExceptionIfThePropertyKeyDoesntExist() throws ProcedureException {
        Mockito.when((Object)this.operations.propertyKeyGetForName("nonExistentProperty")).thenReturn((Object)-1);
        try {
            this.procedure.resampleIndex(":Label(nonExistentProperty)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)org.hamcrest.Matchers.is((Object)Status.Schema.PropertyKeyAccessFailed));
        }
    }

    @Test
    public void shouldLookUpTheIndexByLabelIdAndPropertyKeyId() throws ProcedureException, SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.operations.labelGetForName(Matchers.anyString())).thenReturn((Object)123);
        Mockito.when((Object)this.operations.propertyKeyGetForName(Matchers.anyString())).thenReturn((Object)456);
        Mockito.when((Object)this.operations.indexGetForLabelAndPropertyKey(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)new IndexDescriptor(0, 0));
        this.procedure.resampleIndex(":Person(name)");
        ((ReadOperations)Mockito.verify((Object)this.operations)).indexGetForLabelAndPropertyKey(123, 456);
    }

    @Test
    public void shouldThrowAnExceptionIfTheIndexDoesNotExist() throws SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.operations.labelGetForName(Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.propertyKeyGetForName(Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.indexGetForLabelAndPropertyKey(Matchers.anyInt(), Matchers.anyInt())).thenThrow(new Throwable[]{new IndexSchemaRuleNotFoundException(-1, -1)});
        try {
            this.procedure.resampleIndex(":Person(name)");
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)org.hamcrest.Matchers.is((Object)Status.Schema.IndexNotFound));
        }
    }

    @Test
    public void shouldTriggerResampling() throws SchemaRuleNotFoundException, ProcedureException {
        IndexDescriptor index = new IndexDescriptor(123, 456);
        Mockito.when((Object)this.operations.indexGetForLabelAndPropertyKey(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)index);
        this.procedure.resampleIndex(":Person(name)");
        ((IndexingService)Mockito.verify((Object)this.indexingService)).triggerIndexSampling(index, IndexSamplingMode.TRIGGER_REBUILD_ALL);
    }
}

