/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class LabelCountsTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    private Supplier<Statement> statementSupplier;

    @Test
    public void shouldGetNumberOfNodesWithLabel() throws Exception {
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            graphDb.createNode(new Label[]{Label.label((String)"Foo")});
            graphDb.createNode(new Label[]{Label.label((String)"Bar")});
            graphDb.createNode(new Label[]{Label.label((String)"Bar")});
            tx.success();
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(Label.label((String)"Bar"));
        Assert.assertEquals((long)1L, (long)fooCount);
        Assert.assertEquals((long)2L, (long)barCount);
    }

    @Test
    public void shouldAccountForDeletedNodes() throws Exception {
        Node node;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            node = graphDb.createNode(new Label[]{Label.label((String)"Foo")});
            graphDb.createNode(new Label[]{Label.label((String)"Foo")});
            tx.success();
        }
        tx = graphDb.beginTx();
        var4_4 = null;
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        Assert.assertEquals((long)1L, (long)fooCount);
    }

    @Test
    public void shouldAccountForAddedLabels() throws Exception {
        Node n3;
        Node n2;
        Node n1;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            n1 = graphDb.createNode(new Label[]{Label.label((String)"Foo")});
            n2 = graphDb.createNode();
            n3 = graphDb.createNode();
            tx.success();
        }
        tx = graphDb.beginTx();
        var6_4 = null;
        try {
            n1.addLabel(Label.label((String)"Bar"));
            n2.addLabel(Label.label((String)"Bar"));
            n3.addLabel(Label.label((String)"Foo"));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(Label.label((String)"Bar"));
        Assert.assertEquals((long)2L, (long)fooCount);
        Assert.assertEquals((long)2L, (long)barCount);
    }

    @Test
    public void shouldAccountForRemovedLabels() throws Exception {
        Node n3;
        Node n2;
        Node n1;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            n1 = graphDb.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            n2 = graphDb.createNode(new Label[]{Label.label((String)"Bar")});
            n3 = graphDb.createNode(new Label[]{Label.label((String)"Foo")});
            tx.success();
        }
        tx = graphDb.beginTx();
        var6_4 = null;
        try {
            n1.removeLabel(Label.label((String)"Bar"));
            n2.removeLabel(Label.label((String)"Bar"));
            n3.removeLabel(Label.label((String)"Foo"));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(Label.label((String)"Bar"));
        Assert.assertEquals((long)1L, (long)fooCount);
        Assert.assertEquals((long)0L, (long)barCount);
    }

    private long numberOfNodesWith(Label label) {
        try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
            long nodeCount = this.countsForNode(label);
            tx.success();
            long l = nodeCount;
            return l;
        }
    }

    private long countsForNode(Label label) {
        int labelId;
        ReadOperations read = this.statementSupplier.get().readOperations();
        if (label == null) {
            labelId = -1;
        } else {
            labelId = read.labelGetForName(label.name());
            if (-1 == labelId) {
                return 0L;
            }
        }
        return read.countsForNode(labelId);
    }

    @Before
    public void exposeGuts() {
        this.statementSupplier = (Supplier)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }
}

