/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestGraphDatabaseFactory;

public class LabelRecoveryTest {
    public final EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
    private GraphDatabaseService database;

    @Test
    public void shouldRecoverNodeWithDynamicLabelRecords() throws Exception {
        Node node;
        this.database = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs).newImpermanentDatabase();
        Label[] labels = new Label[]{Label.label((String)"a"), Label.label((String)"b"), Label.label((String)"c"), Label.label((String)"d"), Label.label((String)"e"), Label.label((String)"f"), Label.label((String)"g"), Label.label((String)"h"), Label.label((String)"i"), Label.label((String)"j"), Label.label((String)"k")};
        try (Transaction tx = this.database.beginTx();){
            node = this.database.createNode(labels);
            tx.success();
        }
        tx = this.database.beginTx();
        var4_3 = null;
        try {
            node.setProperty("prop", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot();
        this.database.shutdown();
        this.database = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)snapshot).newImpermanentDatabase();
        try (Transaction ignored = this.database.beginTx();){
            node = this.database.getNodeById(node.getId());
            for (Label label : labels) {
                Assert.assertTrue((boolean)node.hasLabel(label));
            }
        }
    }

    @After
    public void tearDown() {
        if (this.database != null) {
            this.database.shutdown();
        }
        this.fs.shutdown();
    }
}

