/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.CountsOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexReadOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.QueryRegistrationOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.schema.IndexReader;

public abstract class StatementOperationsTestHelper {
    public static StatementOperationParts mockedParts() {
        return new StatementOperationParts((KeyReadOperations)Mockito.mock(KeyReadOperations.class), (KeyWriteOperations)Mockito.mock(KeyWriteOperations.class), (EntityReadOperations)Mockito.mock(EntityReadOperations.class), (EntityWriteOperations)Mockito.mock(EntityWriteOperations.class), (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class), (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class), (SchemaStateOperations)Mockito.mock(SchemaStateOperations.class), (LockOperations)Mockito.mock(LockOperations.class), (CountsOperations)Mockito.mock(CountsOperations.class), (LegacyIndexReadOperations)Mockito.mock(LegacyIndexReadOperations.class), (LegacyIndexWriteOperations)Mockito.mock(LegacyIndexWriteOperations.class), (QueryRegistrationOperations)Mockito.mock(QueryRegistrationOperations.class));
    }

    public static KernelStatement mockedState() {
        return StatementOperationsTestHelper.mockedState((TransactionState)Mockito.mock(TransactionState.class));
    }

    public static KernelStatement mockedState(final TransactionState txState) {
        KernelStatement state = (KernelStatement)Mockito.mock(KernelStatement.class);
        Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
        try {
            IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
            Mockito.when((Object)indexReader.seek(Matchers.any())).thenReturn((Object)PrimitiveLongCollections.emptyIterator());
            StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
            Mockito.when((Object)storageStatement.getIndexReader((IndexDescriptor)Matchers.any())).thenReturn((Object)indexReader);
            Mockito.when((Object)state.getStoreStatement()).thenReturn((Object)storageStatement);
        }
        catch (IndexNotFoundKernelException e) {
            throw new Error(e);
        }
        Mockito.when((Object)state.txState()).thenReturn((Object)txState);
        Mockito.when((Object)state.hasTxStateWithChanges()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return txState.hasChanges();
            }
        });
        Mockito.when((Object)state.locks()).thenReturn((Object)new SimpleStatementLocks(locks));
        Mockito.when((Object)state.readOperations()).thenReturn(Mockito.mock(ReadOperations.class));
        return state;
    }

    private StatementOperationsTestHelper() {
    }
}

