/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.PropertyValueComparison;
import org.neo4j.kernel.impl.api.index.inmemory.HashBasedIndexSampler;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;
import org.neo4j.storageengine.api.schema.IndexSampler;

class HashBasedIndex
extends InMemoryIndexImplementation {
    private Map<Object, Set<Long>> data;

    HashBasedIndex() {
    }

    public Map<Object, Set<Long>> data() {
        if (this.data == null) {
            throw new IllegalStateException("Index has not been created, or has been dropped.");
        }
        return this.data;
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + this.data;
    }

    @Override
    synchronized void initialize() {
        this.data = new HashMap<Object, Set<Long>>();
    }

    @Override
    synchronized void drop() {
        this.data = null;
    }

    @Override
    synchronized PrimitiveLongIterator doIndexSeek(Object propertyValue) {
        Set<Long> nodes = this.data().get(propertyValue);
        return nodes == null ? PrimitiveLongCollections.emptyIterator() : PrimitiveLongCollections.toPrimitiveIterator(nodes.iterator());
    }

    public synchronized PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<Object, Set<Long>> entry : this.data.entrySet()) {
            boolean upperFilter;
            Object key = entry.getKey();
            if (!PropertyValueComparison.SuperType.NUMBER.isSuperTypeOf(key)) continue;
            boolean lowerFilter = lower == null || PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)lower) >= 0;
            boolean bl = upperFilter = upper == null || PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)upper) <= 0;
            if (!lowerFilter || !upperFilter) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    public synchronized PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<Object, Set<Long>> entry : this.data.entrySet()) {
            boolean upperFilter;
            int cmp;
            boolean lowerFilter;
            Object key = entry.getKey();
            if (!PropertyValueComparison.SuperType.STRING.isSuperTypeOf(key)) continue;
            if (lower == null) {
                lowerFilter = true;
            } else {
                cmp = PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)lower);
                boolean bl = lowerFilter = includeLower && cmp >= 0 || cmp > 0;
            }
            if (upper == null) {
                upperFilter = true;
            } else {
                cmp = PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)upper);
                boolean bl = upperFilter = includeUpper && cmp <= 0 || cmp < 0;
            }
            if (!lowerFilter || !upperFilter) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    public synchronized PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
        return this.stringSearch(entry -> entry.startsWith(prefix));
    }

    public synchronized PrimitiveLongIterator containsString(String exactTerm) {
        return this.stringSearch(entry -> entry.contains(exactTerm));
    }

    public PrimitiveLongIterator endsWith(String suffix) {
        return this.stringSearch(entry -> entry.endsWith(suffix));
    }

    public synchronized PrimitiveLongIterator scan() {
        Iterable all = Iterables.flattenIterable(this.data.values());
        return PrimitiveLongCollections.toPrimitiveIterator(all.iterator());
    }

    @Override
    synchronized boolean doAdd(Object propertyValue, long nodeId, boolean applyIdempotently) {
        Set<Long> nodes = this.data().get(propertyValue);
        if (nodes == null) {
            nodes = new HashSet<Long>();
            this.data().put(propertyValue, nodes);
        }
        return nodes.add(nodeId);
    }

    @Override
    synchronized void doRemove(Object propertyValue, long nodeId) {
        Set<Long> nodes = this.data().get(propertyValue);
        if (nodes != null) {
            nodes.remove(nodeId);
        }
    }

    @Override
    synchronized void remove(long nodeId) {
        for (Set<Long> nodes : this.data().values()) {
            nodes.remove(nodeId);
        }
    }

    @Override
    synchronized void iterateAll(InMemoryIndexImplementation.IndexEntryIterator iterator) throws Exception {
        for (Map.Entry<Object, Set<Long>> entry : this.data().entrySet()) {
            iterator.visitEntry(entry.getKey(), entry.getValue());
        }
    }

    public synchronized long maxCount() {
        return this.ids().size();
    }

    public synchronized Iterator<Long> iterator() {
        return this.ids().iterator();
    }

    private Collection<Long> ids() {
        HashSet<Long> allIds = new HashSet<Long>();
        for (Set<Long> someIds : this.data().values()) {
            allIds.addAll(someIds);
        }
        return allIds;
    }

    @Override
    synchronized InMemoryIndexImplementation snapshot() {
        HashBasedIndex snapshot = new HashBasedIndex();
        snapshot.initialize();
        for (Map.Entry<Object, Set<Long>> entry : this.data().entrySet()) {
            snapshot.data().put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return snapshot;
    }

    @Override
    protected synchronized long doCountIndexedNodes(long nodeId, Object propertyValue) {
        Set<Long> candidates = this.data().get(propertyValue);
        return candidates != null && candidates.contains(nodeId) ? 1L : 0L;
    }

    public synchronized IndexSampler createSampler() {
        return new HashBasedIndexSampler(this.data);
    }

    private PrimitiveLongIterator stringSearch(StringFilter filter) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<Object, Set<Long>> entry : this.data.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String) || !filter.test((String)key)) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    private static interface StringFilter {
        public boolean test(String var1);
    }
}

