/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexOperations;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;

public class StateOperationsAutoIndexingTest {
    private final InternalAutoIndexOperations nodeOps = (InternalAutoIndexOperations)Mockito.mock(InternalAutoIndexOperations.class);
    private final InternalAutoIndexOperations relOps = (InternalAutoIndexOperations)Mockito.mock(InternalAutoIndexOperations.class);
    private final AutoIndexing idx = (AutoIndexing)Mockito.mock(InternalAutoIndexing.class);
    private final StorageStatement storeStmt = (StorageStatement)Mockito.mock(StorageStatement.class);
    private final DataWriteOperations writeOps = (DataWriteOperations)Mockito.mock(DataWriteOperations.class);
    private final KernelStatement stmt = (KernelStatement)Mockito.mock(KernelStatement.class, (Answer)Mockito.RETURNS_MOCKS);
    private final StateHandlingStatementOperations context = new StateHandlingStatementOperations((StoreReadLayer)Mockito.mock(StoreReadLayer.class), this.idx, (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));

    @Before
    public void setup() throws InvalidTransactionTypeKernelException {
        Mockito.when((Object)this.idx.nodes()).thenReturn((Object)this.nodeOps);
        Mockito.when((Object)this.idx.relationships()).thenReturn((Object)this.relOps);
        Mockito.when((Object)this.stmt.getStoreStatement()).thenReturn((Object)this.storeStmt);
        Mockito.when((Object)this.stmt.dataWriteOperations()).thenReturn((Object)this.writeOps);
    }

    @Test
    public void shouldSignalNodeRemovedToAutoIndex() throws Exception {
        Mockito.when((Object)this.storeStmt.acquireSingleNodeCursor(Matchers.eq((long)1337L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn((Object)Cursors.cursor((Object[])new NodeItem[]{(NodeItem)Mockito.mock(NodeItem.class)}));
        this.context.nodeDelete(this.stmt, 1337L);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.nodeOps)).entityRemoved(this.writeOps, 1337L);
    }

    @Test
    public void shouldSignalRelationshipRemovedToAutoIndex() throws Exception {
        Mockito.when((Object)this.storeStmt.acquireSingleRelationshipCursor(Matchers.eq((long)1337L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn((Object)Cursors.cursor((Object[])new RelationshipItem[]{(RelationshipItem)Mockito.mock(RelationshipItem.class)}));
        this.context.relationshipDelete(this.stmt, 1337L);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.relOps)).entityRemoved(this.writeOps, 1337L);
    }

    @Test
    public void shouldSignalNodePropertyAddedToAutoIndex() throws Exception {
        DefinedProperty property = Property.property((int)1, (Object)"Hello!");
        NodeItem node = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)node.property(property.propertyKeyId())).thenReturn((Object)Cursors.empty());
        Mockito.when((Object)node.labels()).thenReturn((Object)Cursors.empty());
        Mockito.when((Object)this.storeStmt.acquireSingleNodeCursor(Matchers.eq((long)1337L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn((Object)Cursors.cursor((Object[])new NodeItem[]{node}));
        this.context.nodeSetProperty(this.stmt, 1337L, property);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.nodeOps)).propertyAdded(this.writeOps, 1337L, (Property)property);
    }

    @Test
    public void shouldSignalRelationshipPropertyAddedToAutoIndex() throws Exception {
        DefinedProperty property = Property.property((int)1, (Object)"Hello!");
        RelationshipItem rel = (RelationshipItem)Mockito.mock(RelationshipItem.class);
        Mockito.when((Object)rel.property(property.propertyKeyId())).thenReturn((Object)Cursors.empty());
        Mockito.when((Object)this.storeStmt.acquireSingleRelationshipCursor(Matchers.eq((long)1337L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn((Object)Cursors.cursor((Object[])new RelationshipItem[]{rel}));
        this.context.relationshipSetProperty(this.stmt, 1337L, property);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.relOps)).propertyAdded(this.writeOps, 1337L, (Property)property);
    }

    @Test
    public void shouldSignalNodePropertyChangedToAutoIndex() throws Exception {
        DefinedProperty property = Property.property((int)1, (Object)"Hello!");
        PropertyItem existingProperty = (PropertyItem)Mockito.mock(PropertyItem.class);
        Mockito.when((Object)existingProperty.propertyKeyId()).thenReturn((Object)property.propertyKeyId());
        Mockito.when((Object)existingProperty.value()).thenReturn((Object)"Goodbye!");
        NodeItem node = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)node.property(property.propertyKeyId())).thenReturn((Object)Cursors.cursor((Object[])new PropertyItem[]{existingProperty}));
        Mockito.when((Object)node.labels()).thenReturn((Object)Cursors.empty());
        Mockito.when((Object)this.storeStmt.acquireSingleNodeCursor(Matchers.eq((long)1337L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn((Object)Cursors.cursor((Object[])new NodeItem[]{node}));
        this.context.nodeSetProperty(this.stmt, 1337L, property);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.nodeOps)).propertyChanged((DataWriteOperations)Matchers.eq((Object)this.writeOps), Matchers.eq((long)1337L), (Property)Matchers.any(Property.class), (Property)Matchers.eq((Object)property));
    }

    @Test
    public void shouldSignalRelationshipPropertyChangedToAutoIndex() throws Exception {
        DefinedProperty property = Property.property((int)1, (Object)"Hello!");
        PropertyItem existingProperty = (PropertyItem)Mockito.mock(PropertyItem.class);
        Mockito.when((Object)existingProperty.propertyKeyId()).thenReturn((Object)property.propertyKeyId());
        Mockito.when((Object)existingProperty.value()).thenReturn((Object)"Goodbye!");
        RelationshipItem rel = (RelationshipItem)Mockito.mock(RelationshipItem.class);
        Mockito.when((Object)rel.property(property.propertyKeyId())).thenReturn((Object)Cursors.cursor((Object[])new PropertyItem[]{existingProperty}));
        Mockito.when((Object)this.storeStmt.acquireSingleRelationshipCursor(Matchers.eq((long)1337L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn((Object)Cursors.cursor((Object[])new RelationshipItem[]{rel}));
        this.context.relationshipSetProperty(this.stmt, 1337L, property);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.relOps)).propertyChanged((DataWriteOperations)Matchers.eq((Object)this.writeOps), Matchers.eq((long)1337L), (Property)Matchers.any(Property.class), (Property)Matchers.eq((Object)property));
    }

    @Test
    public void shouldSignalNodePropertyRemovedToAutoIndex() throws Exception {
        PropertyItem existingProperty = (PropertyItem)Mockito.mock(PropertyItem.class);
        Mockito.when((Object)existingProperty.propertyKeyId()).thenReturn((Object)1);
        Mockito.when((Object)existingProperty.value()).thenReturn((Object)"Goodbye!");
        NodeItem node = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)node.property(existingProperty.propertyKeyId())).thenReturn((Object)Cursors.cursor((Object[])new PropertyItem[]{existingProperty}));
        Mockito.when((Object)node.labels()).thenReturn((Object)Cursors.empty());
        Mockito.when((Object)this.storeStmt.acquireSingleNodeCursor(Matchers.eq((long)1337L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn((Object)Cursors.cursor((Object[])new NodeItem[]{node}));
        this.context.nodeRemoveProperty(this.stmt, 1337L, existingProperty.propertyKeyId());
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.nodeOps)).propertyRemoved(this.writeOps, 1337L, existingProperty.propertyKeyId());
    }

    @Test
    public void shouldSignalRelationshipPropertyRemovedToAutoIndex() throws Exception {
        PropertyItem existingProperty = (PropertyItem)Mockito.mock(PropertyItem.class);
        Mockito.when((Object)existingProperty.propertyKeyId()).thenReturn((Object)1);
        Mockito.when((Object)existingProperty.value()).thenReturn((Object)"Goodbye!");
        RelationshipItem rel = (RelationshipItem)Mockito.mock(RelationshipItem.class);
        Mockito.when((Object)rel.property(existingProperty.propertyKeyId())).thenReturn((Object)Cursors.cursor((Object[])new PropertyItem[]{existingProperty}));
        Mockito.when((Object)this.storeStmt.acquireSingleRelationshipCursor(Matchers.eq((long)1337L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn((Object)Cursors.cursor((Object[])new RelationshipItem[]{rel}));
        this.context.relationshipRemoveProperty(this.stmt, 1337L, existingProperty.propertyKeyId());
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.relOps)).propertyRemoved(this.writeOps, 1337L, existingProperty.propertyKeyId());
    }
}

