/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.LongStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.store.StoreSingleLabelCursor;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.StandaloneDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreSingleLabelCursorTest {
    @Test
    public void readNoLabels() {
        StoreSingleLabelCursor cursor = StoreSingleLabelCursorTest.newCursor();
        NodeRecord node = new NodeRecord(1L).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        cursor.init(node, 42);
        Assert.assertFalse((boolean)cursor.next());
    }

    @Test
    public void readInlinedLabelsWithoutSpecifiedLabel() {
        long[] labels = new long[]{1L, 2L, 42L};
        StoreSingleLabelCursor cursor = StoreSingleLabelCursorTest.newCursor();
        NodeRecord node = new NodeRecord(1L).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        Collection allocatedDynamicRecords = InlineNodeLabels.putSorted((NodeRecord)node, (long[])labels, null, null);
        Assert.assertThat((Object)allocatedDynamicRecords, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        cursor.init(node, 3);
        Assert.assertFalse((boolean)cursor.next());
    }

    @Test
    public void readInlinedLabelsWithSpecifiedLabel() {
        long[] labels = new long[]{1L, 2L, 42L};
        StoreSingleLabelCursor cursor = StoreSingleLabelCursorTest.newCursor();
        NodeRecord node = new NodeRecord(1L).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        Collection allocatedDynamicRecords = InlineNodeLabels.putSorted((NodeRecord)node, (long[])labels, null, null);
        Assert.assertThat((Object)allocatedDynamicRecords, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        cursor.init(node, 2);
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertEquals((long)2L, (long)cursor.getAsInt());
        Assert.assertFalse((boolean)cursor.next());
    }

    @Test
    public void readDynamicLabelsWithoutSpecifiedLabel() {
        int maxLabelId = 1000;
        int specifiedLabelId = maxLabelId / 2;
        long[] labels = LongStream.iterate(1L, id -> id + 2L).limit(maxLabelId).toArray();
        NodeRecord node = new NodeRecord(1L).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        Collection allocatedDynamicRecords = DynamicNodeLabels.putSorted((NodeRecord)node, (long[])labels, (NodeStore)((NodeStore)Mockito.mock(NodeStore.class)), (DynamicRecordAllocator)new StandaloneDynamicRecordAllocator());
        for (DynamicRecord dynamicRecord : allocatedDynamicRecords) {
            dynamicRecord.setInUse(true);
        }
        node.setLabelField(node.getLabelField(), Collections.emptyList());
        Assert.assertThat((Object)allocatedDynamicRecords, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        StoreSingleLabelCursor cursor = StoreSingleLabelCursorTest.newCursor(allocatedDynamicRecords);
        cursor.init(node, specifiedLabelId);
        Assert.assertFalse((boolean)cursor.next());
    }

    @Test
    public void readDynamicLabelsWithSpecifiedLabel() {
        int maxLabelId = 1000;
        int specifiedLabelId = maxLabelId / 2 + 1;
        long[] labels = LongStream.iterate(1L, id -> id + 2L).limit(maxLabelId).toArray();
        NodeRecord node = new NodeRecord(1L).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        Collection allocatedDynamicRecords = DynamicNodeLabels.putSorted((NodeRecord)node, (long[])labels, (NodeStore)((NodeStore)Mockito.mock(NodeStore.class)), (DynamicRecordAllocator)new StandaloneDynamicRecordAllocator());
        for (DynamicRecord dynamicRecord : allocatedDynamicRecords) {
            dynamicRecord.setInUse(true);
        }
        node.setLabelField(node.getLabelField(), Collections.emptyList());
        Assert.assertThat((Object)allocatedDynamicRecords, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        StoreSingleLabelCursor cursor = StoreSingleLabelCursorTest.newCursor(allocatedDynamicRecords);
        cursor.init(node, specifiedLabelId);
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertEquals((long)specifiedLabelId, (long)cursor.getAsInt());
        Assert.assertFalse((boolean)cursor.next());
    }

    private static StoreSingleLabelCursor newCursor(Collection<DynamicRecord> recordsForRecordCursor) {
        RecordCursor recordCursor = (RecordCursor)Mockito.mock(RecordCursor.class);
        Mockito.when((Object)recordCursor.getAll()).thenReturn((Object)Iterables.asList(recordsForRecordCursor));
        return new StoreSingleLabelCursor(recordCursor, (InstanceCache)Mockito.mock(InstanceCache.class));
    }

    private static StoreSingleLabelCursor newCursor() {
        return new StoreSingleLabelCursor((RecordCursor)Mockito.mock(RecordCursor.class), (InstanceCache)Mockito.mock(InstanceCache.class));
    }
}

