/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestIsolationBasic
extends AbstractNeo4jTestCase {
    @Test
    public void testSimpleTransactionIsolation() throws Exception {
        Relationship r1;
        Node n2;
        Node n1;
        this.commit();
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        try (Transaction tx = this.getGraphDb().beginTx();){
            n1 = this.getGraphDb().createNode();
            n2 = this.getGraphDb().createNode();
            r1 = n1.createRelationshipTo(n2, RelationshipType.withName((String)"TEST"));
            tx.success();
        }
        final Node node1 = n1;
        final Node node2 = n2;
        final Relationship rel1 = r1;
        try (Transaction tx = this.getGraphDb().beginTx();){
            node1.setProperty("key", (Object)"old");
            rel1.setProperty("key", (Object)"old");
            tx.success();
        }
        this.assertPropertyEqual((PropertyContainer)node1, "key", "old");
        this.assertPropertyEqual((PropertyContainer)rel1, "key", "old");
        this.assertRelationshipCount(node1, 1);
        this.assertRelationshipCount(node2, 1);
        final AtomicReference t1Exception = new AtomicReference();
        Thread t1 = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (Transaction tx = TestIsolationBasic.this.getGraphDb().beginTx();){
                    node1.setProperty("key", (Object)"new");
                    rel1.setProperty("key", (Object)"new");
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)"TEST"));
                    TestIsolationBasic.this.assertPropertyEqual((PropertyContainer)node1, "key", "new");
                    TestIsolationBasic.this.assertPropertyEqual((PropertyContainer)rel1, "key", "new");
                    TestIsolationBasic.this.assertRelationshipCount(node1, 2);
                    TestIsolationBasic.this.assertRelationshipCount(node2, 2);
                    latch1.countDown();
                    latch2.await();
                    TestIsolationBasic.this.assertPropertyEqual((PropertyContainer)node1, "key", "new");
                    TestIsolationBasic.this.assertPropertyEqual((PropertyContainer)rel1, "key", "new");
                    TestIsolationBasic.this.assertRelationshipCount(node1, 2);
                    TestIsolationBasic.this.assertRelationshipCount(node2, 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Thread.interrupted();
                    t1Exception.set(e);
                }
                finally {
                    try {
                        TestIsolationBasic.this.assertPropertyEqual((PropertyContainer)node1, "key", "old");
                        TestIsolationBasic.this.assertPropertyEqual((PropertyContainer)rel1, "key", "old");
                        TestIsolationBasic.this.assertRelationshipCount(node1, 1);
                        TestIsolationBasic.this.assertRelationshipCount(node2, 1);
                    }
                    catch (Exception e) {
                        t1Exception.compareAndSet(null, e);
                    }
                }
            }
        });
        t1.start();
        latch1.await();
        this.assertPropertyEqual((PropertyContainer)node1, "key", "old");
        this.assertPropertyEqual((PropertyContainer)rel1, "key", "old");
        this.assertRelationshipCount(node1, 1);
        this.assertRelationshipCount(node2, 1);
        latch2.countDown();
        t1.join();
        this.assertPropertyEqual((PropertyContainer)node1, "key", "old");
        this.assertPropertyEqual((PropertyContainer)rel1, "key", "old");
        this.assertRelationshipCount(node1, 1);
        this.assertRelationshipCount(node2, 1);
        if (t1Exception.get() != null) {
            throw (Exception)t1Exception.get();
        }
        try (Transaction tx = this.getGraphDb().beginTx();){
            for (Relationship rel : node1.getRelationships()) {
                rel.delete();
            }
            node1.delete();
            node2.delete();
            tx.success();
        }
    }

    private void assertPropertyEqual(PropertyContainer primitive, String key, String value) {
        try (Transaction tx = this.getGraphDb().beginTx();){
            Assert.assertEquals((Object)value, (Object)primitive.getProperty(key));
        }
    }

    private void assertRelationshipCount(Node node, int count) {
        try (Transaction tx = this.getGraphDb().beginTx();){
            int actualCount = 0;
            for (Relationship rel : node.getRelationships()) {
                ++actualCount;
            }
            Assert.assertEquals((long)count, (long)actualCount);
        }
    }
}

