/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TxStateTransactionDataSnapshot;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public class TxStateTransactionDataViewTest {
    private final ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
    private final Statement stmt = (Statement)Mockito.mock(Statement.class);
    private final StoreReadLayer ops = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
    private final StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
    private final KernelTransaction transaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
    private final TransactionState state = new TxState();

    @Before
    public void setup() {
        Mockito.when((Object)this.bridge.get()).thenReturn((Object)this.stmt);
        Mockito.when((Object)this.ops.newStatement()).thenReturn((Object)this.storeStatement);
    }

    @Test
    public void showsCreatedNodes() throws Exception {
        this.state.nodeDoCreate(1L);
        this.state.nodeDoCreate(2L);
        Assert.assertThat(this.idList(this.snapshot().createdNodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
    }

    @Test
    public void showsDeletedNodes() throws Exception {
        this.state.nodeDoDelete(1L);
        this.state.nodeDoDelete(2L);
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(Matchers.eq((long)2L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asNodeCursor(2L, StubCursors.asPropertyCursor(Property.stringProperty((int)1, (String)"p")), StubCursors.asLabelCursor(15)));
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asNodeCursor(1L, StubCursors.asPropertyCursor(new DefinedProperty[0]), StubCursors.asLabelCursor(new Integer[0])));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"key");
        Mockito.when((Object)this.ops.labelGetName(15)).thenReturn((Object)"label");
        TxStateTransactionDataSnapshot snapshot = this.snapshot();
        Assert.assertThat(this.idList(snapshot.deletedNodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat((Object)((LabelEntry)Iterables.single((Iterable)snapshot.removedLabels())).label().name(), (Matcher)CoreMatchers.equalTo((Object)"label"));
        Assert.assertThat((Object)((PropertyEntry)Iterables.single((Iterable)snapshot.removedNodeProperties())).key(), (Matcher)CoreMatchers.equalTo((Object)"key"));
    }

    @Test
    public void showsAddedRelationships() throws Exception {
        this.state.relationshipDoCreate(1L, 1, 1L, 2L);
        this.state.relationshipDoCreate(2L, 1, 1L, 1L);
        Assert.assertThat(this.idList(this.snapshot().createdRelationships()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
    }

    @Test
    public void showsRemovedRelationships() throws Exception {
        this.state.relationshipDoDelete(1L, 1, 1L, 2L);
        this.state.relationshipDoDelete(2L, 1, 1L, 1L);
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asRelationshipCursor(1L, 1, 1L, 2L, StubCursors.asPropertyCursor(new DefinedProperty[0])));
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(Matchers.eq((long)2L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asRelationshipCursor(2L, 1, 1L, 1L, StubCursors.asPropertyCursor(Property.stringProperty((int)1, (String)"p"))));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"key");
        TxStateTransactionDataSnapshot snapshot = this.snapshot();
        Assert.assertThat(this.idList(snapshot.deletedRelationships()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat((Object)((PropertyEntry)Iterables.single((Iterable)snapshot.removedRelationshipProperties())).key(), (Matcher)CoreMatchers.equalTo((Object)"key"));
    }

    @Test
    public void correctlySaysNodeIsDeleted() throws Exception {
        long nodeId = 1L;
        long propertyId = 42L;
        this.state.nodeDoDelete(nodeId);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)1L);
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asNodeCursor(1L));
        Assert.assertThat((Object)this.snapshot().isDeleted(node), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void correctlySaysRelIsDeleted() throws Exception {
        this.state.relationshipDoDelete(1L, 1, 1L, 2L);
        Relationship rel = (Relationship)Mockito.mock(Relationship.class);
        Mockito.when((Object)rel.getId()).thenReturn((Object)1L);
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asRelationshipCursor(1L, 1, 1L, 2L, StubCursors.asPropertyCursor(new DefinedProperty[0])));
        Assert.assertThat((Object)this.snapshot().isDeleted(rel), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldListAddedNodePropertiesProperties() throws Exception {
        DefinedProperty prevProp = Property.stringProperty((int)1, (String)"prevValue");
        this.state.nodeDoReplaceProperty(1L, (Property)prevProp, Property.stringProperty((int)1, (String)"newValue"));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"theKey");
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asNodeCursor(1L, StubCursors.asPropertyCursor(prevProp), StubCursors.asLabelCursor(new Integer[0])));
        Iterable propertyEntries = this.snapshot().assignedNodeProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.value(), (Matcher)CoreMatchers.equalTo((Object)"newValue"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Node)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedNodeProperties() throws Exception {
        DefinedProperty prevProp = Property.stringProperty((int)1, (String)"prevValue");
        this.state.nodeDoRemoveProperty(1L, prevProp);
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"theKey");
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asNodeCursor(1L, StubCursors.asPropertyCursor(prevProp), StubCursors.asLabelCursor(new Integer[0])));
        Iterable propertyEntries = this.snapshot().removedNodeProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Node)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedRelationshipProperties() throws Exception {
        DefinedProperty prevValue = Property.stringProperty((int)1, (String)"prevValue");
        this.state.relationshipDoRemoveProperty(1L, prevValue);
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"theKey");
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asRelationshipCursor(1L, 0, 0L, 0L, StubCursors.asPropertyCursor(prevValue)));
        Iterable propertyEntries = this.snapshot().removedRelationshipProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Relationship)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListAddedRelationshipProperties() throws Exception {
        DefinedProperty prevProp = Property.stringProperty((int)1, (String)"prevValue");
        this.state.relationshipDoReplaceProperty(1L, (Property)prevProp, Property.stringProperty((int)1, (String)"newValue"));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"theKey");
        Mockito.when((Object)this.storeStatement.acquireSingleRelationshipCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asRelationshipCursor(1L, 0, 0L, 0L, StubCursors.asPropertyCursor(prevProp)));
        Iterable propertyEntries = this.snapshot().assignedRelationshipProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.value(), (Matcher)CoreMatchers.equalTo((Object)"newValue"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Relationship)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListAddedLabels() throws Exception {
        this.state.nodeDoAddLabel(2, 1L);
        Mockito.when((Object)this.ops.labelGetName(2)).thenReturn((Object)"theLabel");
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(Matchers.eq((long)1L), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asNodeCursor(1L));
        Iterable labelEntries = this.snapshot().assignedLabels();
        LabelEntry entry = (LabelEntry)Iterables.single((Iterable)labelEntries);
        Assert.assertThat((Object)entry.label().name(), (Matcher)CoreMatchers.equalTo((Object)"theLabel"));
        Assert.assertThat((Object)entry.node().getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedLabels() throws Exception {
        this.state.nodeDoRemoveLabel(2, 1L);
        Mockito.when((Object)this.ops.labelGetName(2)).thenReturn((Object)"theLabel");
        Iterable labelEntries = this.snapshot().removedLabels();
        LabelEntry entry = (LabelEntry)Iterables.single((Iterable)labelEntries);
        Assert.assertThat((Object)entry.label().name(), (Matcher)CoreMatchers.equalTo((Object)"theLabel"));
        Assert.assertThat((Object)entry.node().getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void accessTransactionIdAndCommitTime() {
        long committedTransactionId = 7L;
        long commitTime = 10L;
        Mockito.when((Object)this.transaction.getTransactionId()).thenReturn((Object)committedTransactionId);
        Mockito.when((Object)this.transaction.getCommitTime()).thenReturn((Object)commitTime);
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        Assert.assertEquals((long)committedTransactionId, (long)transactionDataSnapshot.getTransactionId());
        Assert.assertEquals((long)commitTime, (long)transactionDataSnapshot.getCommitTime());
    }

    @Test
    public void shouldGetEmptyUsernameForAnonymousContext() {
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)AnonymousContext.read());
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        Assert.assertEquals((Object)"", (Object)transactionDataSnapshot.username());
    }

    @Test
    public void shouldAccessUsernameFromAuthSubject() {
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)authSubject.username()).thenReturn((Object)"Christof");
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)new SecurityContext.Frozen(authSubject, (AccessMode)AccessMode.Static.FULL));
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        Assert.assertEquals((Object)"Christof", (Object)transactionDataSnapshot.username());
    }

    @Test
    public void shouldAccessEmptyMetaData() {
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        Assert.assertEquals((long)0L, (long)transactionDataSnapshot.metaData().size());
    }

    @Test
    public void shouldAccessExampleMetaData() {
        NodeProxy.NodeActions nodeActions = (NodeProxy.NodeActions)Mockito.mock(NodeProxy.NodeActions.class);
        RelationshipProxy.RelationshipActions relActions = (RelationshipProxy.RelationshipActions)Mockito.mock(RelationshipProxy.RelationshipActions.class);
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)transaction.getMetaData()).thenReturn((Object)MapUtil.genericMap((Object[])new Object[]{"username", "Igor"}));
        TxStateTransactionDataSnapshot transactionDataSnapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)this.state, nodeActions, relActions, this.ops, (StorageStatement)this.storeStatement, (KernelTransaction)transaction);
        Assert.assertEquals((long)1L, (long)transactionDataSnapshot.metaData().size());
        Assert.assertThat((String)"Expected metadata map to contain defined username", (Object)transactionDataSnapshot.metaData(), (Matcher)CoreMatchers.equalTo((Object)MapUtil.genericMap((Object[])new Object[]{"username", "Igor"})));
    }

    private List<Long> idList(Iterable<? extends PropertyContainer> entities) {
        ArrayList<Long> out = new ArrayList<Long>();
        for (PropertyContainer propertyContainer : entities) {
            out.add(propertyContainer instanceof Node ? ((Node)propertyContainer).getId() : ((Relationship)propertyContainer).getId());
        }
        return out;
    }

    private TxStateTransactionDataSnapshot snapshot() {
        NodeProxy.NodeActions nodeActions = (NodeProxy.NodeActions)Mockito.mock(NodeProxy.NodeActions.class);
        RelationshipProxy.RelationshipActions relActions = (RelationshipProxy.RelationshipActions)Mockito.mock(RelationshipProxy.RelationshipActions.class);
        return new TxStateTransactionDataSnapshot((ReadableTransactionState)this.state, nodeActions, relActions, this.ops, (StorageStatement)this.storeStatement, this.transaction);
    }
}

