/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureAllowedConfig;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.UserFunction;

public class ReflectiveUserFunctionTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ReflectiveProcedureCompiler procedureCompiler;
    private ComponentRegistry components;

    @Before
    public void setUp() throws Exception {
        this.components = new ComponentRegistry();
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, (Log)NullLog.getInstance(), ProcedureAllowedConfig.DEFAULT);
    }

    @Test
    public void shouldInjectLogging() throws KernelException {
        Log log = (Log)Mockito.spy(Log.class);
        this.components.register(Log.class, ctx -> log);
        CallableUserFunction function = (CallableUserFunction)this.procedureCompiler.compileFunction(LoggingFunction.class).get(0);
        function.apply((Context)new BasicContext(), new Object[0]);
        ((Log)Mockito.verify((Object)log)).debug("1");
        ((Log)Mockito.verify((Object)log)).info("2");
        ((Log)Mockito.verify((Object)log)).warn("3");
        ((Log)Mockito.verify((Object)log)).error("4");
    }

    @Test
    public void shouldCompileFunction() throws Throwable {
        List<CallableUserFunction> function = this.compile(SingleReadOnlyFunction.class);
        TestCase.assertEquals((int)1, (int)function.size());
        Assert.assertThat((Object)function.get(0).signature(), (Matcher)Matchers.equalTo((Object)UserFunctionSignature.functionSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "listCoolPeople"}).out((Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTAny)).build()));
    }

    @Test
    public void shouldRunSimpleReadOnlyFunction() throws Throwable {
        CallableUserFunction func = this.compile(SingleReadOnlyFunction.class).get(0);
        Object out = func.apply((Context)new BasicContext(), new Object[0]);
        Assert.assertThat((Object)out, (Matcher)CoreMatchers.equalTo(Arrays.asList("Bonnie", "Clyde")));
    }

    @Test
    public void shouldIgnoreClassesWithNoFunctions() throws Throwable {
        List<CallableUserFunction> functions = this.compile(PrivateConstructorButNoFunctions.class);
        TestCase.assertEquals((int)0, (int)functions.size());
    }

    @Test
    public void shouldRunClassWithMultipleFunctionsDeclared() throws Throwable {
        List<CallableUserFunction> compiled = this.compile(MultiFunction.class);
        CallableUserFunction bananaPeople = compiled.get(0);
        CallableUserFunction coolPeople = compiled.get(1);
        Object coolOut = coolPeople.apply((Context)new BasicContext(), new Object[0]);
        Object bananaOut = bananaPeople.apply((Context)new BasicContext(), new Object[0]);
        Assert.assertThat((Object)coolOut, (Matcher)CoreMatchers.equalTo(Arrays.asList("Bonnie", "Clyde")));
        Assert.assertThat(((Map)bananaOut).get("foo"), (Matcher)CoreMatchers.equalTo(Arrays.asList("bar", "baz")));
    }

    @Test
    public void shouldGiveHelpfulErrorOnConstructorThatRequiresArgument() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `WierdConstructorFunction`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(WierdConstructorFunction.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnNoPublicConstructor() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `PrivateConstructorFunction`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(PrivateConstructorFunction.class);
    }

    @Test
    public void shouldNotAllowVoidOutput() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Don't know how to map `void` to the Neo4j Type System.");
        this.compile(FunctionWithVoidOutput.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnFunctionReturningInvalidType() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Don't know how to map `char[]` to the Neo4j Type System.%nPlease refer to to the documentation for full details.%nFor your reference, known types are: [boolean, double, java.lang.Boolean, java.lang.Double, java.lang.Long, java.lang.Number, java.lang.Object, java.lang.String, java.util.List, java.util.Map, long]", new Object[0]));
        this.compile(FunctionWithInvalidOutput.class).get(0);
    }

    @Test
    public void shouldGiveHelpfulErrorOnContextAnnotatedStaticField() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("The field `gdb` in the class named `FunctionWithStaticContextAnnotatedField` is annotated as a @Context field,%nbut it is static. @Context fields must be public, non-final and non-static,%nbecause they are reset each time a procedure is invoked.", new Object[0]));
        this.compile(FunctionWithStaticContextAnnotatedField.class).get(0);
    }

    @Test
    public void shouldAllowOverridingProcedureName() throws Throwable {
        CallableUserFunction proc = this.compile(FunctionWithOverriddenName.class).get(0);
        TestCase.assertEquals((String)"org.mystuff.thisisActuallyTheName", (String)proc.signature().name().toString());
    }

    @Test
    public void shouldNotAllowOverridingFunctionNameWithoutNamespace() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("It is not allowed to define functions in the root namespace please use a namespace, e.g. `@UserFunction(\"org.example.com.singleName\")");
        this.compile(FunctionWithSingleName.class).get(0);
    }

    @Test
    public void shouldGiveHelpfulErrorOnNullMessageException() throws Throwable {
        CallableUserFunction proc = this.compile(FunctionThatThrowsNullMsgExceptionAtInvocation.class).get(0);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Failed to invoke function `org.neo4j.kernel.impl.proc.throwsAtInvocation`: Caused by: java.lang.IndexOutOfBoundsException");
        proc.apply((Context)new BasicContext(), new Object[0]);
    }

    @Test
    public void shouldSupportFunctionDeprecation() throws Throwable {
        Log log = (Log)Mockito.mock(Log.class);
        ReflectiveProcedureCompiler procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, log, ProcedureAllowedConfig.DEFAULT);
        List funcs = procedureCompiler.compileFunction(FunctionWithDeprecation.class);
        ((Log)Mockito.verify((Object)log)).warn("Use of @UserFunction(deprecatedBy) without @Deprecated in org.neo4j.kernel.impl.proc.badFunc");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
        block9: for (CallableUserFunction func : funcs) {
            String name = func.signature().name().name();
            func.apply((Context)new BasicContext(), new Object[0]);
            switch (name) {
                case "newFunc": {
                    Assert.assertFalse((String)"Should not be deprecated", (boolean)func.signature().deprecated().isPresent());
                    continue block9;
                }
                case "oldFunc": 
                case "badFunc": {
                    Assert.assertTrue((String)"Should be deprecated", (boolean)func.signature().deprecated().isPresent());
                    Assert.assertThat(func.signature().deprecated().get(), (Matcher)CoreMatchers.equalTo((Object)"newFunc"));
                    continue block9;
                }
            }
            Assert.fail((String)("Unexpected function: " + name));
        }
    }

    private List<CallableUserFunction> compile(Class<?> clazz) throws KernelException {
        return this.procedureCompiler.compileFunction(clazz);
    }

    public static class FunctionWithDeprecation {
        @UserFunction
        public Object newFunc() {
            return null;
        }

        @Deprecated
        @UserFunction(deprecatedBy="newFunc")
        public String oldFunc() {
            return null;
        }

        @UserFunction(deprecatedBy="newFunc")
        public Object badFunc() {
            return null;
        }
    }

    public static class FunctionWithSingleName {
        @UserFunction(value="singleName")
        public String blahDoesntMatterEither() {
            return null;
        }
    }

    public static class FunctionWithOverriddenName {
        @UserFunction(value="org.mystuff.thisisActuallyTheName")
        public Object somethingThatShouldntMatter() {
            return null;
        }
    }

    public static class PrivateConstructorButNoFunctions {
        private PrivateConstructorButNoFunctions() {
        }

        public String thisIsNotAFunction() {
            return null;
        }
    }

    public static class PrivateConstructorFunction {
        private PrivateConstructorFunction() {
        }

        @UserFunction
        public List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }
    }

    public static class FunctionThatThrowsNullMsgExceptionAtInvocation {
        @UserFunction
        public String throwsAtInvocation() {
            throw new IndexOutOfBoundsException();
        }
    }

    public static class FunctionWithStaticContextAnnotatedField {
        @org.neo4j.procedure.Context
        public static GraphDatabaseService gdb;

        @UserFunction
        public Object test() {
            return null;
        }
    }

    public static class FunctionWithInvalidOutput {
        @UserFunction
        public char[] test() {
            return "Testing".toCharArray();
        }
    }

    public static class WierdConstructorFunction {
        public WierdConstructorFunction(WierdConstructorFunction wat) {
        }

        @UserFunction
        public List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }
    }

    public static class MultiFunction {
        @UserFunction
        public List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }

        @UserFunction
        public Map<String, Object> listBananaOwningPeople() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("foo", Arrays.asList("bar", "baz"));
            return map;
        }
    }

    public static class FunctionWithVoidOutput {
        @UserFunction
        public void voidOutput() {
        }
    }

    public static class SingleReadOnlyFunction {
        @UserFunction
        public List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }
    }

    public static class LoggingFunction {
        @org.neo4j.procedure.Context
        public Log log;

        @UserFunction
        public long logAround() {
            this.log.debug("1");
            this.log.info("2");
            this.log.warn("3");
            this.log.error("4");
            return -1L;
        }
    }
}

