/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;

public class RelationshipGroupStoreTest {
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule(false);
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    private File directory;
    private int defaultThreshold;
    private FileSystemAbstraction fs;
    private ImpermanentGraphDatabase db;

    @Before
    public void before() throws Exception {
        this.directory = this.testDir.graphDbDir();
        this.fs = new DefaultFileSystemAbstraction();
        this.defaultThreshold = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
    }

    @After
    public void after() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Test
    public void createWithDefaultThreshold() throws Exception {
        this.createAndVerify(null);
    }

    @Test
    public void createWithCustomThreshold() throws Exception {
        this.createAndVerify(this.defaultThreshold * 2);
    }

    @Test
    public void createDenseNodeWithLowThreshold() throws Exception {
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            Assert.assertEquals((long)2L, (long)node.getDegree());
            Assert.assertEquals((long)1L, (long)node.getDegree((RelationshipType)MyRelTypes.TEST));
            Assert.assertEquals((long)1L, (long)node.getDegree((RelationshipType)MyRelTypes.TEST2));
            tx.success();
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.db.shutdown();
    }

    private void newDb(int denseNodeThreshold) {
        this.db = new ImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{"dbms.relationship_grouping_threshold", "" + denseNodeThreshold}));
        this.fs = (FileSystemAbstraction)this.db.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
    }

    private void createAndVerify(Integer customThreshold) {
        int expectedThreshold = customThreshold != null ? customThreshold : this.defaultThreshold;
        StoreFactory factory = this.factory(customThreshold);
        NeoStores neoStores = factory.openAllNeoStores(true);
        Assert.assertEquals((long)expectedThreshold, (long)neoStores.getRelationshipGroupStore().getStoreHeaderInt());
        neoStores.close();
        neoStores = factory.openAllNeoStores();
        Assert.assertEquals((long)expectedThreshold, (long)neoStores.getRelationshipGroupStore().getStoreHeaderInt());
        neoStores.close();
        factory = this.factory(999999);
        neoStores = factory.openAllNeoStores();
        Assert.assertEquals((long)expectedThreshold, (long)neoStores.getRelationshipGroupStore().getStoreHeaderInt());
        neoStores.close();
    }

    private StoreFactory factory(Integer customThreshold) {
        return this.factory(customThreshold, this.pageCacheRule.getPageCache(this.fs));
    }

    private StoreFactory factory(Integer customThreshold, PageCache pageCache) {
        HashMap<String, String> customConfig = new HashMap<String, String>();
        if (customThreshold != null) {
            customConfig.put(GraphDatabaseSettings.dense_node_threshold.name(), "" + customThreshold);
        }
        return new StoreFactory(this.directory, new Config(customConfig), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), pageCache, this.fs, (LogProvider)NullLogProvider.getInstance());
    }

    @Test
    public void makeSureRelationshipGroupsNextAndPrevGetsAssignedCorrectly() throws Exception {
        this.newDb(1);
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            Node node0 = this.db.createNode();
            Node node2 = this.db.createNode();
            node0.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            node.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            for (Relationship rel : node.getRelationships()) {
                rel.delete();
            }
            node.delete();
            tx.success();
        }
        this.db.shutdown();
    }

    @Test
    public void verifyRecordsForDenseNodeWithOneRelType() throws Exception {
        Relationship rel6;
        Relationship rel5;
        Relationship rel4;
        Relationship rel3;
        Relationship rel2;
        Relationship rel1;
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            rel1 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel2 = this.db.createNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel3 = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel4 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel5 = this.db.createNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel6 = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        NeoStores neoStores = ((RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)RecordStore.getRecord((RecordStore)nodeStore, (long)node.getId());
        long group = nodeRecord.getNextRel();
        RecordStore groupStore = neoStores.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)RecordStore.getRecord((RecordStore)groupStore, (long)group);
        Assert.assertEquals((long)-1L, (long)groupRecord.getNext());
        Assert.assertEquals((long)-1L, (long)groupRecord.getPrev());
        this.assertRelationshipChain(neoStores.getRelationshipStore(), node, groupRecord.getFirstOut(), rel1.getId(), rel4.getId());
        this.assertRelationshipChain(neoStores.getRelationshipStore(), node, groupRecord.getFirstIn(), rel2.getId(), rel5.getId());
        this.assertRelationshipChain(neoStores.getRelationshipStore(), node, groupRecord.getFirstLoop(), rel3.getId(), rel6.getId());
    }

    @Test
    public void verifyRecordsForDenseNodeWithTwoRelTypes() throws Exception {
        Relationship rel6;
        Relationship rel5;
        Relationship rel4;
        Relationship rel3;
        Relationship rel2;
        Relationship rel1;
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            rel1 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel2 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel3 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel4 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            rel5 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            rel6 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            tx.success();
        }
        NeoStores neoStores = ((RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)RecordStore.getRecord((RecordStore)nodeStore, (long)node.getId());
        long group = nodeRecord.getNextRel();
        RecordStore groupStore = neoStores.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)RecordStore.getRecord((RecordStore)groupStore, (long)group);
        Assert.assertFalse((groupRecord.getNext() == -1L ? 1 : 0) != 0);
        this.assertRelationshipChain(neoStores.getRelationshipStore(), node, groupRecord.getFirstOut(), rel1.getId(), rel2.getId(), rel3.getId());
        RelationshipGroupRecord otherGroupRecord = (RelationshipGroupRecord)RecordStore.getRecord((RecordStore)groupStore, (long)groupRecord.getNext());
        Assert.assertEquals((long)-1L, (long)otherGroupRecord.getNext());
        this.assertRelationshipChain(neoStores.getRelationshipStore(), node, otherGroupRecord.getFirstOut(), rel4.getId(), rel5.getId(), rel6.getId());
    }

    @Test
    public void verifyGroupIsDeletedWhenNeeded() throws Exception {
        this.newDb(2);
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Relationship rel1 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel2 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel3 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel4 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
        Relationship rel5 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
        Relationship rel6 = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
        tx.success();
        tx.close();
        NeoStores neoStores = ((RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)RecordStore.getRecord((RecordStore)nodeStore, (long)node.getId());
        long group = nodeRecord.getNextRel();
        RecordStore groupStore = neoStores.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)RecordStore.getRecord((RecordStore)groupStore, (long)group);
        Assert.assertFalse((groupRecord.getNext() == -1L ? 1 : 0) != 0);
        RelationshipGroupRecord otherGroupRecord = (RelationshipGroupRecord)groupStore.getRecord(groupRecord.getNext(), groupStore.newRecord(), RecordLoad.NORMAL);
        Assert.assertEquals((long)-1L, (long)otherGroupRecord.getNext());
    }

    @Test
    public void checkingIfRecordIsInUseMustHappenAfterConsistentRead() {
        AtomicBoolean nextReadIsInconsistent = new AtomicBoolean(false);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        pageCache = this.pageCacheRule.withInconsistentReads(pageCache, nextReadIsInconsistent);
        StoreFactory factory = this.factory(null, pageCache);
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            RecordStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
            RelationshipGroupRecord record = new RelationshipGroupRecord(1L).initialize(true, 2, 3L, 4L, 5L, 6L, (long)Record.NO_NEXT_RELATIONSHIP.intValue());
            relationshipGroupStore.updateRecord((AbstractBaseRecord)record);
            nextReadIsInconsistent.set(true);
            RelationshipGroupRecord readBack = (RelationshipGroupRecord)relationshipGroupStore.getRecord(1L, relationshipGroupStore.newRecord(), RecordLoad.NORMAL);
            Assert.assertThat((Object)readBack.toString(), (Matcher)Matchers.equalTo((Object)record.toString()));
        }
    }

    private void assertRelationshipChain(RelationshipStore relationshipStore, Node node, long firstId, long ... chainedIds) {
        long nodeId = node.getId();
        RelationshipRecord record = (RelationshipRecord)relationshipStore.getRecord(firstId, relationshipStore.newRecord(), RecordLoad.NORMAL);
        HashSet<Long> readChain = new HashSet<Long>();
        readChain.add(firstId);
        while (true) {
            long nextId;
            long l = nextId = record.getFirstNode() == nodeId ? record.getFirstNextRel() : record.getSecondNextRel();
            if (nextId == -1L) break;
            readChain.add(nextId);
            relationshipStore.getRecord(nextId, (AbstractBaseRecord)record, RecordLoad.NORMAL);
        }
        HashSet<Long> expectedChain = new HashSet<Long>(Arrays.asList(firstId));
        for (long id : chainedIds) {
            expectedChain.add(id);
        }
        Assert.assertEquals(expectedChain, readChain);
    }
}

