/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class TestGraphProperties {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private TestGraphDatabaseFactory factory;
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();

    @Before
    public void before() throws Exception {
        this.factory = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get());
    }

    @Test
    public void basicProperties() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        PropertyContainer graphProperties = TestGraphProperties.properties(db);
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty("test"))));
        Transaction tx = db.beginTx();
        graphProperties.setProperty("test", (Object)"yo");
        Assert.assertEquals((Object)"yo", (Object)graphProperties.getProperty("test"));
        tx.success();
        tx.close();
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("test").withValue("yo")));
        tx = db.beginTx();
        Assert.assertNull((Object)graphProperties.removeProperty("something non existent"));
        Assert.assertEquals((Object)"yo", (Object)graphProperties.removeProperty("test"));
        Assert.assertNull((Object)graphProperties.getProperty("test", null));
        graphProperties.setProperty("other", (Object)10);
        Assert.assertEquals((Object)10, (Object)graphProperties.getProperty("other"));
        graphProperties.setProperty("new", (Object)"third");
        tx.success();
        tx.close();
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty("test"))));
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("other").withValue(10)));
        Assert.assertThat(Neo4jMatchers.getPropertyKeys((GraphDatabaseService)db, graphProperties), Neo4jMatchers.containsOnly("other", "new"));
        tx = db.beginTx();
        graphProperties.setProperty("rollback", (Object)true);
        Assert.assertEquals((Object)true, (Object)graphProperties.getProperty("rollback"));
        tx.close();
        Assert.assertThat((Object)graphProperties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty("rollback"))));
        db.shutdown();
    }

    @Test
    public void setManyGraphProperties() throws Exception {
        int i;
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Transaction tx = db.beginTx();
        Object[] values = new Object[]{10, "A string value", new float[]{1234.567f, 7654.321f}, "A rather longer string which wouldn't fit inlined #!)(&\u00a4"};
        int count = 200;
        for (i = 0; i < count; ++i) {
            TestGraphProperties.properties(db).setProperty("key" + i, values[i % values.length]);
        }
        tx.success();
        tx.close();
        for (i = 0; i < count; ++i) {
            Assert.assertThat((Object)TestGraphProperties.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("key" + i).withValue(values[i % values.length])));
        }
        for (i = 0; i < count; ++i) {
            Assert.assertThat((Object)TestGraphProperties.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("key" + i).withValue(values[i % values.length])));
        }
        db.shutdown();
    }

    @Test
    public void setBigArrayGraphProperty() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        long[] array = new long[1000];
        for (int i = 0; i < 10; ++i) {
            array[array.length / 10 * i] = i;
        }
        String key = "big long array";
        Transaction tx = db.beginTx();
        TestGraphProperties.properties(db).setProperty(key, (Object)array);
        Assert.assertThat((Object)TestGraphProperties.properties(db), (Matcher)Neo4jMatchers.hasProperty(key).withValue(array));
        tx.success();
        tx.close();
        Assert.assertThat((Object)TestGraphProperties.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key).withValue(array)));
        Assert.assertThat((Object)TestGraphProperties.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key).withValue(array)));
        db.shutdown();
    }

    private static PropertyContainer properties(GraphDatabaseAPI db) {
        return ((NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class)).newGraphProperties();
    }

    @Test
    public void firstRecordOtherThanZeroIfNotFirst() throws Exception {
        File storeDir = new File("/store/dir").getAbsoluteFile();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase(storeDir);
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Yo");
        tx.success();
        tx.close();
        db.shutdown();
        db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase(storeDir);
        tx = db.beginTx();
        TestGraphProperties.properties(db).setProperty("test", (Object)"something");
        tx.success();
        tx.close();
        db.shutdown();
        Config config = new Config(Collections.emptyMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory storeFactory = new StoreFactory(storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = storeFactory.openAllNeoStores();
        long prop = neoStores.getMetaDataStore().getGraphNextProp();
        Assert.assertTrue((prop != 0L ? 1 : 0) != 0);
        neoStores.close();
    }

    @Test
    public void graphPropertiesAreLockedPerTx() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Worker worker1 = new Worker("W1", new State(db));
        Worker worker2 = new Worker("W2", new State(db));
        PropertyContainer properties = TestGraphProperties.properties(db);
        worker1.beginTx();
        worker2.beginTx();
        String key1 = "name";
        String value1 = "Value 1";
        String key2 = "some other property";
        String value2 = "Value 2";
        String key3 = "say";
        String value3 = "hello";
        worker1.setProperty(key1, value1).get();
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key1))));
        Assert.assertFalse((boolean)worker2.hasProperty(key1));
        Future<Void> blockedSetProperty = worker2.setProperty(key2, value2);
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key1))));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key2))));
        worker1.setProperty(key3, value3).get();
        Assert.assertFalse((boolean)blockedSetProperty.isDone());
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key1))));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key2))));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key3))));
        worker1.commitTx();
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key1)));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty(key2))));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key3)));
        blockedSetProperty.get();
        Assert.assertTrue((boolean)blockedSetProperty.isDone());
        worker2.commitTx();
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key1).withValue(value1)));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key2).withValue(value2)));
        Assert.assertThat((Object)properties, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty(key3).withValue(value3)));
        worker1.close();
        worker2.close();
        db.shutdown();
    }

    @Test
    public void twoUncleanInARow() throws Exception {
        File storeDir = new File("dir");
        EphemeralFileSystemAbstraction snapshot = this.produceUncleanStore(this.fs.get(), storeDir);
        snapshot = this.produceUncleanStore(snapshot, storeDir);
        snapshot = this.produceUncleanStore(snapshot, storeDir);
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)snapshot).newImpermanentDatabase(storeDir);
        Assert.assertThat((Object)TestGraphProperties.properties(db), Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("prop").withValue("Some value")));
        db.shutdown();
    }

    @Test
    public void testEquals() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        PropertyContainer graphProperties = TestGraphProperties.properties(db);
        try (Transaction tx = db.beginTx();){
            graphProperties.setProperty("test", (Object)"test");
            tx.success();
        }
        Assert.assertEquals((Object)graphProperties, (Object)TestGraphProperties.properties(db));
        db.shutdown();
        db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Assert.assertFalse((boolean)graphProperties.equals(TestGraphProperties.properties(db)));
        db.shutdown();
    }

    @Test
    public void shouldBeAbleToCreateLongGraphPropertyChainsAndReadTheCorrectNextPointerFromTheStore() {
        GraphDatabaseService database = this.factory.newImpermanentDatabase();
        PropertyContainer graphProperties = TestGraphProperties.properties((GraphDatabaseAPI)database);
        try (Transaction tx = database.beginTx();){
            graphProperties.setProperty("a", (Object)new String[]{"A", "B", "C", "D", "E"});
            graphProperties.setProperty("b", (Object)true);
            graphProperties.setProperty("c", (Object)"C");
            tx.success();
        }
        tx = database.beginTx();
        var4_4 = null;
        try {
            graphProperties.setProperty("d", (Object)new String[]{"A", "F"});
            graphProperties.setProperty("e", (Object)true);
            graphProperties.setProperty("f", (Object)"F");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = database.beginTx();
        var4_4 = null;
        try {
            graphProperties.setProperty("g", (Object)new String[]{"F"});
            graphProperties.setProperty("h", (Object)false);
            graphProperties.setProperty("i", (Object)"I");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = database.beginTx();
        var4_4 = null;
        try {
            Assert.assertArrayEquals((Object[])new String[]{"A", "B", "C", "D", "E"}, (Object[])((String[])graphProperties.getProperty("a")));
            Assert.assertTrue((boolean)((Boolean)graphProperties.getProperty("b")));
            Assert.assertEquals((Object)"C", (Object)graphProperties.getProperty("c"));
            Assert.assertArrayEquals((Object[])new String[]{"A", "F"}, (Object[])((String[])graphProperties.getProperty("d")));
            Assert.assertTrue((boolean)((Boolean)graphProperties.getProperty("e")));
            Assert.assertEquals((Object)"F", (Object)graphProperties.getProperty("f"));
            Assert.assertArrayEquals((Object[])new String[]{"F"}, (Object[])((String[])graphProperties.getProperty("g")));
            Assert.assertFalse((boolean)((Boolean)graphProperties.getProperty("h")));
            Assert.assertEquals((Object)"I", (Object)graphProperties.getProperty("i"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        database.shutdown();
    }

    private EphemeralFileSystemAbstraction produceUncleanStore(EphemeralFileSystemAbstraction fileSystem, File storeDir) {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).newImpermanentDatabase(storeDir);
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Something");
        TestGraphProperties.properties((GraphDatabaseAPI)db).setProperty("prop", (Object)"Some value");
        tx.success();
        tx.close();
        EphemeralFileSystemAbstraction snapshot = fileSystem.snapshot();
        db.shutdown();
        return snapshot;
    }

    private static class Worker
    extends OtherThreadExecutor<State> {
        public Worker(String name, State initialState) {
            super(name, initialState);
        }

        public boolean hasProperty(final String key) throws Exception {
            return this.execute(new OtherThreadExecutor.WorkerCommand<State, Boolean>(){

                @Override
                public Boolean doWork(State state) {
                    return state.properties.hasProperty(key);
                }
            });
        }

        public void commitTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx.success();
                    state.tx.close();
                    return null;
                }
            });
        }

        void beginTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx = state.db.beginTx();
                    return null;
                }
            });
        }

        Future<Void> setProperty(final String key, final Object value) throws Exception {
            return this.executeDontWait(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.properties.setProperty(key, value);
                    return null;
                }
            });
        }
    }

    private static class State {
        private final GraphDatabaseAPI db;
        private final PropertyContainer properties;
        private Transaction tx;

        State(GraphDatabaseAPI db) {
            this.db = db;
            this.properties = TestGraphProperties.properties(db);
        }
    }
}

