/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicatorTestUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class IndexLookupTest {
    @ClassRule
    public static EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(IndexLookupTest.class);
    private static GraphDatabaseAPI api;
    private static IndexLookup indexLookup;
    private static long indexedNode;
    private static long notIndexedNode;
    private static long usedLabelId;
    private static long notUsedLabelId;
    private static int notUsedPropertyId;
    private static int usedPropertyId;
    private static String indexedNodePropertyValue;
    private static String notIndexedNodePropertyValue;

    @BeforeClass
    public static void setUp() {
        api = dbRule.getGraphDatabaseAPI();
        String notUsedIndexPropKey = "notUsed";
        String usedIndexPropKey = "used";
        Label usedLabel = Label.label((String)"UsedLabel");
        Label notUsedLabel = Label.label((String)"NotUsedLabel");
        try (Transaction transaction = api.beginTx();){
            api.schema().indexFor(usedLabel).on(usedIndexPropKey).create();
            transaction.success();
        }
        transaction = api.beginTx();
        var5_5 = null;
        try {
            api.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            indexedNodePropertyValue = "value1";
            notIndexedNodePropertyValue = "value2";
            Node nodeA = api.createNode(new Label[]{usedLabel});
            nodeA.setProperty(usedIndexPropKey, (Object)indexedNodePropertyValue);
            nodeA.setProperty(notUsedIndexPropKey, (Object)notIndexedNodePropertyValue);
            indexedNode = nodeA.getId();
            Node nodeB = api.createNode(new Label[]{notUsedLabel});
            nodeB.setProperty(usedIndexPropKey, (Object)notIndexedNodePropertyValue);
            nodeB.setProperty(notUsedIndexPropKey, (Object)indexedNodePropertyValue);
            notIndexedNode = nodeB.getId();
            transaction.success();
        }
        catch (Throwable nodeA) {
            var5_5 = nodeA;
            throw nodeA;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable nodeA) {
                        var5_5.addSuppressed(nodeA);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        DependencyResolver resolver = api.getDependencyResolver();
        NeoStores neoStores = ((RecordStorageEngine)resolver.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        SchemaStore schemaStore = neoStores.getSchemaStore();
        SchemaIndexProvider schemaIndexProvider = (SchemaIndexProvider)resolver.resolveDependency(SchemaIndexProvider.class);
        indexLookup = new IndexLookup(schemaStore, schemaIndexProvider);
        LabelTokenStore labelTokenStore = neoStores.getLabelTokenStore();
        notUsedLabelId = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)labelTokenStore, notUsedLabel.name()).id();
        usedLabelId = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)labelTokenStore, usedLabel.name()).id();
        PropertyKeyTokenStore propertyKeyTokenStore = neoStores.getPropertyKeyTokenStore();
        notUsedPropertyId = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)propertyKeyTokenStore, notUsedIndexPropKey).id();
        usedPropertyId = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)propertyKeyTokenStore, usedIndexPropKey).id();
    }

    @Test
    public void getAnyIndexOrNullMustReturnNullWhenThereIsNoSuchIndex() throws Exception {
        IndexLookup.Index index = indexLookup.getAnyIndexOrNull(new long[]{usedLabelId, notUsedLabelId}, notUsedPropertyId);
        Assert.assertThat((Object)index, (Matcher)Matchers.nullValue());
        index = indexLookup.getAnyIndexOrNull(new long[]{notUsedLabelId}, usedPropertyId);
        Assert.assertThat((Object)index, (Matcher)Matchers.nullValue());
    }

    @Test
    public void getAnyIndexOrNullMustReturnAnyRelevantIndex() throws Exception {
        IndexLookup.Index index = indexLookup.getAnyIndexOrNull(new long[]{usedLabelId, notUsedLabelId}, usedPropertyId);
        Assert.assertThat((Object)index, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void containsMustReturnTrueForAnIndexedNodeAndPropertyValue() throws Exception {
        IndexLookup.Index index = indexLookup.getAnyIndexOrNull(new long[]{usedLabelId, notUsedLabelId}, usedPropertyId);
        Assert.assertTrue((boolean)index.contains(indexedNode, (Object)indexedNodePropertyValue));
    }

    @Test
    public void containsMustReturnFalseWhenNodeIsNotIndexed() throws Exception {
        IndexLookup.Index index = indexLookup.getAnyIndexOrNull(new long[]{usedLabelId, notUsedLabelId}, usedPropertyId);
        Assert.assertFalse((boolean)index.contains(notIndexedNode, (Object)indexedNodePropertyValue));
        Assert.assertFalse((boolean)index.contains(notIndexedNode, (Object)notIndexedNodePropertyValue));
    }

    @Test
    public void containsMustReturnFalseWhenTheValueIsNotIndexed() throws Exception {
        IndexLookup.Index index = indexLookup.getAnyIndexOrNull(new long[]{usedLabelId, notUsedLabelId}, usedPropertyId);
        Assert.assertFalse((boolean)index.contains(indexedNode, (Object)notIndexedNodePropertyValue));
    }
}

