/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryTimespanThreshold;

public class EntryTimespanThresholdTest {
    private final File file = (File)Mockito.mock(File.class);
    private final LogFileInformation source = (LogFileInformation)Mockito.mock(LogFileInformation.class);
    private final long version = 4L;
    private Clock clock = Clock.fixed(Instant.ofEpochMilli(1000L), ZoneOffset.UTC);

    @Test
    public void shouldReturnFalseWhenTimeIsEqualOrAfterTheLowerLimit() throws IOException {
        EntryTimespanThreshold threshold = new EntryTimespanThreshold(this.clock, TimeUnit.MILLISECONDS, 200L);
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenReturn((Object)800L);
        threshold.init();
        boolean result = threshold.reached(this.file, 4L, this.source);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnReturnWhenTimeIsBeforeTheLowerLimit() throws IOException {
        EntryTimespanThreshold threshold = new EntryTimespanThreshold(this.clock, TimeUnit.MILLISECONDS, 100L);
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenReturn((Object)800L);
        threshold.init();
        boolean result = threshold.reached(this.file, 4L, this.source);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldThrowIfTheLogCannotBeRead() throws IOException {
        EntryTimespanThreshold threshold = new EntryTimespanThreshold(this.clock, TimeUnit.MILLISECONDS, 100L);
        IOException ex = new IOException();
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenThrow(new Throwable[]{ex});
        threshold.init();
        try {
            threshold.reached(this.file, 4L, this.source);
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)ex, (Object)e.getCause());
        }
    }
}

