/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.function.Predicate;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestMultipleFilters
extends TraversalTestBase {
    private Transaction tx;

    @Before
    public void setupGraph() {
        this.createGraph("a TO b", "b TO d", "b TO e", "b TO k", "a TO c", "c TO f", "c TO k");
        this.tx = this.beginTx();
    }

    @After
    public void tearDown() {
        this.tx.close();
    }

    @Test
    public void testNarrowingFilters() {
        MustBeConnectedToNodeFilter mustBeConnectedToK = new MustBeConnectedToNodeFilter(this.getNodeWithName("k"));
        Evaluator mustNotHaveMoreThanTwoOutRels = path -> Evaluation.ofIncludes((Iterables.count((Iterable)path.endNode().getRelationships(Direction.OUTGOING)) <= 2L ? 1 : 0) != 0);
        TraversalDescription description = this.getGraphDb().traversalDescription().evaluator((Evaluator)mustBeConnectedToK);
        this.expectNodes(description.traverse(this.node("a")), "b", "c");
        this.expectNodes(description.evaluator(mustNotHaveMoreThanTwoOutRels).traverse(this.node("a")), "c");
    }

    @Test
    public void testBroadeningFilters() {
        MustBeConnectedToNodeFilter mustBeConnectedToC = new MustBeConnectedToNodeFilter(this.getNodeWithName("c"));
        MustBeConnectedToNodeFilter mustBeConnectedToE = new MustBeConnectedToNodeFilter(this.getNodeWithName("e"));
        this.expectNodes(this.getGraphDb().traversalDescription().evaluator((Evaluator)mustBeConnectedToC).traverse(this.node("a")), "a");
        this.expectNodes(this.getGraphDb().traversalDescription().evaluator((Evaluator)mustBeConnectedToC).evaluator((Evaluator)mustBeConnectedToE).traverse(this.node("a")), new String[0]);
        this.expectNodes(this.getGraphDb().traversalDescription().evaluator(Evaluators.includeIfAcceptedByAny((Evaluator[])new Evaluator[]{mustBeConnectedToC, mustBeConnectedToE})).traverse(this.node("a")), "a", "b");
    }

    private static class MustBeConnectedToNodeFilter
    implements Predicate<Path>,
    Evaluator {
        private final Node node;

        MustBeConnectedToNodeFilter(Node node) {
            this.node = node;
        }

        @Override
        public boolean test(Path item) {
            for (Relationship rel : item.endNode().getRelationships(Direction.OUTGOING)) {
                if (!rel.getEndNode().equals(this.node)) continue;
                return true;
            }
            return false;
        }

        public Evaluation evaluate(Path path) {
            return this.test(path) ? Evaluation.INCLUDE_AND_CONTINUE : Evaluation.EXCLUDE_AND_CONTINUE;
        }
    }
}

