/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.AutoCreatingHashMap;

public class AutoCreatingHashMapTest {
    @Test
    public void shouldCreateValuesIfMissing() throws Exception {
        AutoCreatingHashMap map = new AutoCreatingHashMap(AutoCreatingHashMap.values(AtomicLong.class));
        String key = "should be created";
        ((AtomicLong)map.get(key)).incrementAndGet();
        Assert.assertEquals((long)1L, (long)((AtomicLong)map.get(key)).get());
        Assert.assertTrue((boolean)map.containsKey(key));
        Assert.assertFalse((boolean)map.containsKey("any other key"));
    }

    @Test
    public void shouldCreateValuesEvenForNestedMaps() throws Exception {
        AutoCreatingHashMap map = new AutoCreatingHashMap(AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.values(AtomicLong.class))));
        String keyLevelOne = "first";
        String keyLevelTwo = "second";
        String keyLevelThree = "third";
        ((AtomicLong)((Map)((Map)map.get(keyLevelOne)).get(keyLevelTwo)).get(keyLevelThree)).addAndGet(10L);
        Assert.assertTrue((boolean)map.containsKey(keyLevelOne));
        Assert.assertFalse((boolean)map.containsKey(keyLevelTwo));
        Map levelOne = (Map)map.get(keyLevelOne);
        Assert.assertTrue((boolean)levelOne.containsKey(keyLevelTwo));
        Assert.assertFalse((boolean)levelOne.containsKey(keyLevelThree));
        Map levelTwo = (Map)levelOne.get(keyLevelTwo);
        Assert.assertTrue((boolean)levelTwo.containsKey(keyLevelThree));
        Assert.assertFalse((boolean)levelTwo.containsKey(keyLevelOne));
        AtomicLong levelThree = (AtomicLong)levelTwo.get(keyLevelThree);
        Assert.assertEquals((long)10L, (long)levelThree.get());
    }
}

