/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.ReflectionUtil;

public class Neo4jJobSchedulerTest {
    private final AtomicInteger invocations = new AtomicInteger();
    private final LifeSupport life = new LifeSupport();
    private final Neo4jJobScheduler scheduler = (Neo4jJobScheduler)this.life.add((Lifecycle)new Neo4jJobScheduler());
    private final Runnable countInvocationsJob = () -> {
        try {
            this.invocations.incrementAndGet();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw Exceptions.launderedException((Throwable)e);
        }
    };

    @After
    public void stopScheduler() throws Throwable {
        this.life.shutdown();
    }

    @Test
    public void shouldRunRecurringJob() throws Throwable {
        long period = 1000L;
        int count = 2;
        this.life.start();
        this.scheduler.scheduleRecurring(JobScheduler.Groups.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitFirstInvocation();
        Thread.sleep(period * (long)count - period / 2L);
        this.scheduler.shutdown();
        int actualInvocations = this.invocations.get();
        Assert.assertEquals((long)count, (long)actualInvocations);
        Thread.sleep(period);
        MatcherAssert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.equalTo((Object)actualInvocations));
    }

    @Test
    public void shouldCancelRecurringJob() throws Exception {
        long period = 2L;
        this.life.start();
        JobScheduler.JobHandle jobHandle = this.scheduler.scheduleRecurring(JobScheduler.Groups.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitFirstInvocation();
        jobHandle.cancel(false);
        int recorded = this.invocations.get();
        Thread.sleep(period * 100L);
        MatcherAssert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.equalTo((Object)recorded));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRunJobInNewThread() throws Throwable {
        this.life.start();
        CountDownLatch threadStarted = new CountDownLatch(1);
        CountDownLatch unblockThread = new CountDownLatch(1);
        this.scheduler.schedule(new JobScheduler.Group("MyGroup", JobScheduler.SchedulingStrategy.NEW_THREAD), this.waitForLatch(threadStarted, unblockThread), MapUtil.stringMap((String[])new String[]{"thread-id", "MyTestThread"}));
        threadStarted.await();
        try {
            String threadName = "neo4j.MyGroup-MyTestThread";
            for (String name : this.threadNames()) {
                if (!name.equals(threadName)) continue;
                return;
            }
            TestCase.fail((String)("Expected a thread named '" + threadName + "' in " + this.threadNames()));
        }
        finally {
            unblockThread.countDown();
        }
    }

    @Test
    public void shouldRunWithDelay() throws Throwable {
        this.life.start();
        final AtomicLong runTime = new AtomicLong();
        final CountDownLatch latch = new CountDownLatch(1);
        long time = System.nanoTime();
        this.scheduler.schedule(new JobScheduler.Group("group", JobScheduler.SchedulingStrategy.POOLED), new Runnable(){

            @Override
            public void run() {
                runTime.set(System.nanoTime());
                latch.countDown();
            }
        }, 100L, TimeUnit.MILLISECONDS);
        latch.await();
        Assert.assertTrue((time + TimeUnit.MILLISECONDS.toNanos(100L) <= runTime.get() ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotSwallowExceptions() throws Exception {
        Neo4jJobScheduler neo4jJobScheduler = new Neo4jJobScheduler();
        neo4jJobScheduler.init();
        ExecutorService es = (ExecutorService)Mockito.mock(ExecutorService.class);
        ((ExecutorService)Mockito.doThrow((Throwable)new RuntimeException("ES")).when((Object)es)).shutdown();
        ReflectionUtil.replaceValueInPrivateField(neo4jJobScheduler, "globalPool", ExecutorService.class, es);
        ScheduledThreadPoolExecutor stpe = (ScheduledThreadPoolExecutor)Mockito.mock(ScheduledThreadPoolExecutor.class);
        ((ScheduledThreadPoolExecutor)Mockito.doThrow((Throwable)new RuntimeException("STPE")).when((Object)stpe)).shutdown();
        ReflectionUtil.replaceValueInPrivateField(neo4jJobScheduler, "scheduledExecutor", ScheduledThreadPoolExecutor.class, stpe);
        try {
            neo4jJobScheduler.shutdown();
        }
        catch (RuntimeException t) {
            Assert.assertEquals((Object)"Unable to shut down job scheduler properly.", (Object)t.getMessage());
            Throwable inner = t.getCause();
            Assert.assertEquals((Object)"ES", (Object)inner.getMessage());
            Assert.assertEquals((long)1L, (long)inner.getSuppressed().length);
            Assert.assertEquals((Object)"STPE", (Object)inner.getSuppressed()[0].getMessage());
        }
    }

    private List<String> threadNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            names.add(thread.getName());
        }
        return names;
    }

    private Runnable waitForLatch(CountDownLatch threadStarted, CountDownLatch runUntil) {
        return () -> {
            try {
                threadStarted.countDown();
                runUntil.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private void awaitFirstInvocation() {
        while (this.invocations.get() == 0) {
            Thread.yield();
        }
    }
}

