/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class LatestCheckPointFinderTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final File directory = new File("/somewhere");
    private final LogEntryReader<ReadableClosablePositionAwareChannel> reader = new VersionAwareLogEntryReader();
    private LatestCheckPointFinder finder;
    private PhysicalLogFiles logFiles;
    private final int startLogVersion;
    private final int endLogVersion;

    public LatestCheckPointFinderTest(Integer startLogVersion, Integer endLogVersion) {
        this.startLogVersion = startLogVersion;
        this.endLogVersion = endLogVersion;
    }

    @Parameterized.Parameters(name="{0},{1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({1, 2}, {42, 43});
    }

    @Before
    public void setUp() {
        this.fsRule.get().mkdirs(this.directory);
        this.logFiles = new PhysicalLogFiles(this.directory, (FileSystemAbstraction)this.fsRule.get());
        this.finder = new LatestCheckPointFinder(this.logFiles, (FileSystemAbstraction)this.fsRule.get(), this.reader);
    }

    @Test
    public void noLogFilesFound() throws Throwable {
        this.setupLogFiles(new LogCreator[0]);
        int logVersion = this.startLogVersion;
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, (FileSystemAbstraction)this.fsRule.get(), this.reader);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)logVersion);
        this.assertLatestCheckPoint(false, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, -1L, latestCheckPoint);
    }

    @Test
    public void oneLogFileNoCheckPoints() throws Throwable {
        int logVersion = this.endLogVersion;
        this.setupLogFiles(this.logFile(new Entry[0]));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)logVersion);
        this.assertLatestCheckPoint(false, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, logVersion, latestCheckPoint);
    }

    @Test
    public void oneLogFileNoCheckPointsOneStart() throws Throwable {
        int logVersion = this.endLogVersion;
        long txId = 10L;
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(txId)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)logVersion);
        this.assertLatestCheckPoint(false, true, txId, logVersion, latestCheckPoint);
    }

    @Test
    public void twoLogFilesNoCheckPoints() throws Throwable {
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(new Entry[0]));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(false, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.startLogVersion, latestCheckPoint);
    }

    @Test
    public void twoLogFilesNoCheckPointsOneStart() throws Throwable {
        long txId = 21L;
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(txId)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(false, true, txId, this.startLogVersion, latestCheckPoint);
    }

    @Test
    public void twoLogFilesNoCheckPointsOneStartWithoutCommit() throws Throwable {
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LatestCheckPointFinderTest.start()));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(false, true, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.startLogVersion, latestCheckPoint);
    }

    @Test
    public void twoLogFilesNoCheckPointsTwoCommits() throws Throwable {
        long txId = 21L;
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(txId), LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(txId + 1L)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(false, true, txId, this.startLogVersion, latestCheckPoint);
    }

    @Test
    public void twoLogFilesCheckPointTargetsPrevious() throws Exception {
        long txId = 6L;
        PositionEntry position = LatestCheckPointFinderTest.position();
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(txId - 1L), position), this.logFile(LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(txId)), this.logFile(LatestCheckPointFinderTest.checkPoint(position)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointOnly() throws Throwable {
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.checkPoint()));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartBefore() throws Throwable {
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.checkPoint()));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartAfter() throws Throwable {
        long txId = 35L;
        StartEntry start = LatestCheckPointFinderTest.start();
        this.setupLogFiles(this.logFile(start, LatestCheckPointFinderTest.commit(txId), LatestCheckPointFinderTest.checkPoint(start)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartWithoutCommitAfter() throws Throwable {
        StartEntry start = LatestCheckPointFinderTest.start();
        this.setupLogFiles(this.logFile(start, LatestCheckPointFinderTest.checkPoint(start)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, true, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartInBetween() throws Throwable {
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.checkPoint(), LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.checkPoint()));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartAfterBoth() throws Throwable {
        long txId = 11L;
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.checkPoint(), LatestCheckPointFinderTest.checkPoint(), LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(txId)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileContainingAStart() throws Throwable {
        long txId = 11L;
        StartEntry start = LatestCheckPointFinderTest.start();
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.checkPoint()), this.logFile(start, LatestCheckPointFinderTest.commit(txId)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, true, txId, this.startLogVersion, latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileIsEmpty() throws Throwable {
        StartEntry start = LatestCheckPointFinderTest.start();
        this.setupLogFiles(this.logFile(start, LatestCheckPointFinderTest.checkPoint()), this.logFile(new Entry[0]));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.startLogVersion, latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStart() throws Throwable {
        long txId = 123L;
        StartEntry start = LatestCheckPointFinderTest.start();
        this.setupLogFiles(this.logFile(start, LatestCheckPointFinderTest.commit(txId)), this.logFile(LatestCheckPointFinderTest.checkPoint(start)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStartWithoutCommit() throws Throwable {
        StartEntry start = LatestCheckPointFinderTest.start();
        this.setupLogFiles(this.logFile(start), this.logFile(LatestCheckPointFinderTest.checkPoint(start)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToALaterPositionThanStart() throws Throwable {
        PositionEntry position = LatestCheckPointFinderTest.position();
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(3L), position), this.logFile(LatestCheckPointFinderTest.checkPoint(position)));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, false, LatestCheckPointFinder.LatestCheckPoint.NO_TRANSACTION_ID, this.endLogVersion, latestCheckPoint);
    }

    @Test
    public void latestLogEmptyStartEntryBeforeAndAfterCheckPointInTheLastButOneLog() throws Throwable {
        long txId = 432L;
        this.setupLogFiles(this.logFile(LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.checkPoint(), LatestCheckPointFinderTest.start(), LatestCheckPointFinderTest.commit(txId)), this.logFile(new Entry[0]));
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.finder.find((long)this.endLogVersion);
        this.assertLatestCheckPoint(true, true, txId, this.startLogVersion, latestCheckPoint);
    }

    @SafeVarargs
    private final void setupLogFiles(LogCreator ... logFiles) throws IOException {
        HashMap<Entry, LogPosition> positions = new HashMap<Entry, LogPosition>();
        long version = this.endLogVersion - logFiles.length;
        for (LogCreator logFile : logFiles) {
            logFile.create(++version, positions);
        }
    }

    private LogCreator logFile(Entry ... entries) {
        return (logVersion, positions) -> {
            try {
                AtomicLong lastTxId = new AtomicLong();
                Supplier<Long> lastTxIdSupplier = () -> lastTxId.get();
                DeadSimpleLogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(logVersion);
                LifeSupport life = new LifeSupport();
                life.start();
                PhysicalLogFile logFile = (PhysicalLogFile)life.add((Lifecycle)new PhysicalLogFile((FileSystemAbstraction)this.fsRule.get(), this.logFiles, ByteUnit.mebiBytes((long)1L), lastTxIdSupplier, (LogVersionRepository)logVersionRepository, PhysicalLogFile.NO_MONITOR, new LogHeaderCache(10)));
                try {
                    FlushablePositionAwareChannel writeChannel = logFile.getWriter();
                    LogPositionMarker positionMarker = new LogPositionMarker();
                    LogEntryWriter writer = new LogEntryWriter((FlushableChannel)writeChannel);
                    for (Entry entry : entries) {
                        LogPosition currentPosition = writeChannel.getCurrentPosition(positionMarker).newPosition();
                        positions.put(entry, currentPosition);
                        if (entry instanceof StartEntry) {
                            writer.writeStartEntry(0, 0, 0L, 0L, new byte[0]);
                            continue;
                        }
                        if (entry instanceof CommitEntry) {
                            CommitEntry commitEntry = (CommitEntry)entry;
                            writer.writeCommitEntry(commitEntry.txId, 0L);
                            lastTxId.set(commitEntry.txId);
                            continue;
                        }
                        if (entry instanceof CheckPointEntry) {
                            LogPosition logPosition;
                            CheckPointEntry checkPointEntry = (CheckPointEntry)entry;
                            Entry target = checkPointEntry.withPositionOfEntry;
                            LogPosition logPosition2 = logPosition = target != null ? (LogPosition)positions.get(target) : currentPosition;
                            assert (logPosition != null) : "No registered log position for " + target;
                            writer.writeCheckPointEntry(logPosition);
                            continue;
                        }
                        if (entry instanceof PositionEntry) continue;
                        throw new IllegalArgumentException("Unknown entry " + entry);
                    }
                }
                finally {
                    life.shutdown();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static StartEntry start() {
        return new StartEntry();
    }

    private static CommitEntry commit(long txId) {
        return new CommitEntry(txId);
    }

    private static CheckPointEntry checkPoint() {
        return LatestCheckPointFinderTest.checkPoint(null);
    }

    private static CheckPointEntry checkPoint(Entry forEntry) {
        return new CheckPointEntry(forEntry);
    }

    private static PositionEntry position() {
        return new PositionEntry();
    }

    private void assertLatestCheckPoint(boolean hasCheckPointEntry, boolean commitsAfterLastCheckPoint, long firstTxIdAfterLastCheckPoint, long logVersion, LatestCheckPointFinder.LatestCheckPoint latestCheckPoint) {
        Assert.assertEquals((Object)hasCheckPointEntry, (Object)(latestCheckPoint.checkPoint != null ? 1 : 0));
        Assert.assertEquals((Object)commitsAfterLastCheckPoint, (Object)latestCheckPoint.commitsAfterCheckPoint);
        if (commitsAfterLastCheckPoint) {
            Assert.assertEquals((long)firstTxIdAfterLastCheckPoint, (long)latestCheckPoint.firstTxIdAfterLastCheckPoint);
        }
        Assert.assertEquals((long)logVersion, (long)latestCheckPoint.oldestLogVersionFound);
    }

    private static class PositionEntry
    implements Entry {
        private PositionEntry() {
        }
    }

    private static class CheckPointEntry
    implements Entry {
        final Entry withPositionOfEntry;

        CheckPointEntry(Entry withPositionOfEntry) {
            this.withPositionOfEntry = withPositionOfEntry;
        }
    }

    private static class CommitEntry
    implements Entry {
        final long txId;

        CommitEntry(long txId) {
            this.txId = txId;
        }
    }

    private static class StartEntry
    implements Entry {
        private StartEntry() {
        }
    }

    static interface Entry {
    }

    static interface LogCreator {
        public void create(long var1, Map<Entry, LogPosition> var3) throws IOException;
    }
}

