/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import org.junit.rules.ExternalResource;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.rule.DatabaseRule;

public class GraphTransactionRule
extends ExternalResource {
    private final DatabaseRule database;
    private Transaction tx;

    public GraphTransactionRule(DatabaseRule database) {
        this.database = database;
    }

    protected void before() throws Throwable {
        this.begin();
    }

    protected void after() {
        this.success();
    }

    public Transaction current() {
        return this.tx;
    }

    public Transaction begin() {
        this.tx = this.database.getGraphDatabaseAPI().beginTx();
        return this.tx;
    }

    public void success() {
        try {
            if (this.tx != null) {
                this.tx.success();
                this.tx.close();
            }
        }
        finally {
            this.tx = null;
        }
    }

    public void failure() {
        try {
            if (this.tx != null) {
                this.tx.failure();
                this.tx.close();
            }
        }
        finally {
            this.tx = null;
        }
    }
}

