/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.rule.RetryHandler;

public class RetryOnTransientFailure
implements RetryHandler {
    private final int maxRetryCount;
    private final long timeBetweenTries;
    private final TimeUnit unit;
    private int retries;

    public RetryOnTransientFailure() {
        this(5, 1L, TimeUnit.SECONDS);
    }

    public RetryOnTransientFailure(int maxRetryCount, long timeBetweenTries, TimeUnit unit) {
        this.maxRetryCount = maxRetryCount;
        this.timeBetweenTries = timeBetweenTries;
        this.unit = unit;
    }

    @Override
    public boolean retryOn(Throwable t) {
        if (this.isTransientFailure(t)) {
            LockSupport.parkNanos(this.unit.toNanos(this.timeBetweenTries));
            return this.retries++ < this.maxRetryCount;
        }
        return false;
    }

    private boolean isTransientFailure(Throwable t) {
        Status status;
        if (t instanceof TransientFailureException) {
            return true;
        }
        return t instanceof Status.HasStatus && (status = ((Status.HasStatus)t).status()).code().classification() == Status.Classification.TransientError;
    }
}

