/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.unsafe.impl.batchimport.Configuration;

public class ConfigurationTest {
    @Test
    public void shouldOverrideBigPageCacheMemorySettingContainingUnit() throws Exception {
        Config dbConfig = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "2g"}));
        Configuration.Overridden config = new Configuration.Overridden(dbConfig);
        long memory = config.pageCacheMemory();
        Assert.assertEquals((long)Configuration.MAX_PAGE_CACHE_MEMORY, (long)memory);
    }

    @Test
    public void shouldOverrideSmallPageCacheMemorySettingContainingUnit() throws Exception {
        long overridden = Settings.parseLongWithUnit((String)"10m");
        Config dbConfig = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), String.valueOf(overridden)}));
        Configuration.Overridden config = new Configuration.Overridden(dbConfig);
        long memory = config.pageCacheMemory();
        Assert.assertEquals((long)overridden, (long)memory);
    }

    @Test
    public void shouldParseDefaultPageCacheMemorySetting() throws Exception {
        Configuration config = Configuration.DEFAULT;
        long memory = config.pageCacheMemory();
        long heuristic = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory();
        Assert.assertTrue((boolean)this.within(memory, heuristic, Configuration.MAX_PAGE_CACHE_MEMORY));
    }

    private boolean within(long value, long firstBound, long otherBound) {
        return value >= Math.min(firstBound, otherBound) && value <= Math.max(firstBound, otherBound);
    }

    private Configuration configWithPageCacheMemory(final long bytes) {
        return new Configuration(){

            public long pageCacheMemory() {
                return bytes;
            }
        };
    }
}

