/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipTypeCheckerStep;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipTypeCheckerStepTest {
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldReturnRelationshipTypeIdsInReverseOrderOfTokenCreation() throws Throwable {
        this.shouldReturnRelationshipTypeIdsInReverseOrderOfTokenCreation(true);
    }

    @Test
    public void shouldReturnRelationshipTypeNamesInReverseOrderOfTokenCreation() throws Throwable {
        this.shouldReturnRelationshipTypeIdsInReverseOrderOfTokenCreation(false);
    }

    private void shouldReturnRelationshipTypeIdsInReverseOrderOfTokenCreation(boolean typeIds) throws Throwable {
        BatchingTokenRepository.BatchingRelationshipTypeTokenRepository repository = (BatchingTokenRepository.BatchingRelationshipTypeTokenRepository)Mockito.mock(BatchingTokenRepository.BatchingRelationshipTypeTokenRepository.class);
        RelationshipTypeCheckerStep step = new RelationshipTypeCheckerStep((StageControl)Mockito.mock(StageControl.class), Configuration.DEFAULT, repository);
        Batch<InputRelationship, RelationshipRecord> relationships = this.batchOfRelationshipsWithRandomTypes(10, typeIds);
        step.process(relationships, (BatchSender)Mockito.mock(BatchSender.class));
        step.done();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{repository});
        for (Map.Entry type : Iterables.reverse((Iterable)step.getDistribution())) {
            ((BatchingTokenRepository.BatchingRelationshipTypeTokenRepository)inOrder.verify((Object)repository)).getOrCreateId(type.getKey());
        }
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldReturnRelationshipTypesInDescendingOrder() throws Throwable {
        BatchingTokenRepository.BatchingRelationshipTypeTokenRepository repository = (BatchingTokenRepository.BatchingRelationshipTypeTokenRepository)Mockito.mock(BatchingTokenRepository.BatchingRelationshipTypeTokenRepository.class);
        RelationshipTypeCheckerStep step = new RelationshipTypeCheckerStep((StageControl)Mockito.mock(StageControl.class), Configuration.DEFAULT, repository);
        Batch<InputRelationship, RelationshipRecord> relationships = this.batchOfRelationshipsWithRandomTypes(10, true);
        step.process(relationships, (BatchSender)Mockito.mock(BatchSender.class));
        step.done();
        TreeSet<Integer> expected = this.idsOf(relationships);
        Iterator processed = step.getDistribution().iterator();
        for (Object expectedType : Iterators.loop(expected.descendingIterator())) {
            Map.Entry entry = (Map.Entry)processed.next();
            Assert.assertEquals(expectedType, entry.getKey());
        }
    }

    private TreeSet<Integer> idsOf(Batch<InputRelationship, RelationshipRecord> relationships) {
        TreeSet<Integer> types = new TreeSet<Integer>();
        for (InputRelationship relationship : (InputRelationship[])relationships.input) {
            types.add(relationship.typeId());
        }
        return types;
    }

    private Batch<InputRelationship, RelationshipRecord> batchOfRelationshipsWithRandomTypes(int maxTypes, boolean typeIds) {
        Object[] relationships = new InputRelationship[100];
        for (int i = 0; i < relationships.length; ++i) {
            int typeId = this.random.nextInt(maxTypes);
            relationships[i] = new InputRelationship("test", (long)i, (long)i, InputEntity.NO_PROPERTIES, null, Group.GLOBAL, (Object)0L, Group.GLOBAL, (Object)0L, typeIds ? null : "TYPE_" + String.valueOf(typeId), typeIds ? Integer.valueOf(typeId) : null);
        }
        return new Batch(relationships);
    }

    private Object[] reversed(Object[] objects) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(objects));
        Collections.reverse(list);
        return list.toArray();
    }
}

