/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;

public class TopLevelTransactionTest {
    @Test
    public void shouldThrowTransientExceptionOnTransientKernelException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable)new TransactionFailureException((Status)Status.Transaction.ConstraintsChanged, "Proving that TopLevelTransaction does the right thing", new Object[0])).when((Object)kernelTransaction)).close();
        ThreadToStatementContextBridge bridge = new ThreadToStatementContextBridge();
        TopLevelTransaction transaction = new TopLevelTransaction(kernelTransaction, (Supplier)bridge);
        transaction.success();
        try {
            transaction.close();
            Assert.fail((String)"Should have failed");
        }
        catch (TransientTransactionFailureException transientTransactionFailureException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowTransactionExceptionOnTransientKernelException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable)new RuntimeException("Just a random failure")).when((Object)kernelTransaction)).close();
        ThreadToStatementContextBridge bridge = new ThreadToStatementContextBridge();
        TopLevelTransaction transaction = new TopLevelTransaction(kernelTransaction, (Supplier)bridge);
        transaction.success();
        try {
            transaction.close();
            Assert.fail((String)"Should have failed");
        }
        catch (org.neo4j.graphdb.TransactionFailureException transactionFailureException) {
            // empty catch block
        }
    }

    @Test
    public void shouldLetThroughTransientFailureException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable)new TransientDatabaseFailureException("Just a random failure")).when((Object)kernelTransaction)).close();
        ThreadToStatementContextBridge bridge = new ThreadToStatementContextBridge();
        TopLevelTransaction transaction = new TopLevelTransaction(kernelTransaction, (Supplier)bridge);
        transaction.success();
        try {
            transaction.close();
            Assert.fail((String)"Should have failed");
        }
        catch (TransientFailureException transientFailureException) {
            // empty catch block
        }
    }

    @Test
    public void shouldShowTransactionTerminatedExceptionAsTransient() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        ((KernelTransaction)Mockito.doReturn((Object)true).when((Object)kernelTransaction)).isOpen();
        TransactionTerminatedException error = new TransactionTerminatedException((Status)Status.Transaction.Terminated);
        ((KernelTransaction)Mockito.doThrow((Throwable)error).when((Object)kernelTransaction)).close();
        ThreadToStatementContextBridge bridge = new ThreadToStatementContextBridge();
        TopLevelTransaction transaction = new TopLevelTransaction(kernelTransaction, (Supplier)bridge);
        transaction.success();
        try {
            transaction.close();
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransientTransactionFailureException.class));
            Assert.assertSame((Object)error, (Object)e.getCause());
        }
    }
}

