/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class NonUniqueIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public NonUniqueIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite);
    }

    @Test
    public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
        IndexConfiguration config = IndexConfiguration.NON_UNIQUE;
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, config, indexSamplingConfig);
        populator.create();
        populator.add(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)0, (Object)"value1", (long[])new long[]{0L}), NodePropertyUpdate.add((long)2L, (int)0, (Object)"value1", (long[])new long[]{0L})));
        populator.close(true);
        IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, new IndexDescriptor(1, 2), config, indexSamplingConfig);
        try (IndexReader reader = accessor.newReader();){
            PrimitiveLongIterator nodes = reader.seek((Object)"value1");
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes));
        }
        accessor.close();
    }

    @Test
    public void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        IndexConfiguration config = IndexConfiguration.NON_UNIQUE;
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, config, indexSamplingConfig);
        String failure = "The contrived failure";
        populator.create();
        populator.markAsFailed(failure);
        Assert.assertEquals((Object)failure, (Object)this.indexProvider.getPopulationFailure(17L));
    }

    @Test
    public void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexConfiguration config = IndexConfiguration.NON_UNIQUE;
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, config, indexSamplingConfig);
        String failure = "The contrived failure";
        populator.create();
        populator.markAsFailed(failure);
        Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(17L));
    }

    @Test
    public void shouldBeAbleToDropAClosedIndexPopulator() throws Exception {
        IndexConfiguration config = IndexConfiguration.NON_UNIQUE;
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, config, indexSamplingConfig);
        populator.close(false);
        populator.drop();
    }

    @Test
    public void shouldApplyUpdatesIdempotently() throws Exception {
        IndexConfiguration config = IndexConfiguration.NON_UNIQUE;
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, config, indexSamplingConfig);
        populator.create();
        populator.configureSampling(true);
        long nodeId = 1L;
        int propertyKeyId = 10;
        int labelId = 11;
        String propertyValue = "value1";
        PropertyAccessor propertyAccessor = new PropertyAccessor(){

            public Property getProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
                return Property.stringProperty((int)propertyKeyId, (String)"value1");
            }
        };
        populator.add(Collections.singletonList(NodePropertyUpdate.add((long)nodeId, (int)0, (Object)"value1", (long[])new long[]{0L})));
        try (IndexUpdater updater = populator.newPopulatingUpdater(propertyAccessor);){
            updater.process(NodePropertyUpdate.add((long)nodeId, (int)propertyKeyId, (Object)"value1", (long[])new long[]{labelId}));
        }
        populator.close(true);
        IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, new IndexDescriptor(labelId, propertyKeyId), IndexConfiguration.NON_UNIQUE, indexSamplingConfig);
        try (IndexReader reader = accessor.newReader();){
            PrimitiveLongIterator nodes = reader.seek((Object)"value1");
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes));
        }
        accessor.close();
    }
}

