/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.DuplicateIndexSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.IndexSchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.OperationsFacade;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.test.mockito.matcher.KernelExceptionUserMessageMatcher;

@RunWith(value=MockitoJUnitRunner.class)
public class OperationsFacadeTest {
    private final String LABEL1 = "Label1";
    private final String PROP1 = "Prop1";
    private final int LABEL1_ID = 1;
    private final int PROP1_ID = 2;
    @Mock
    private KernelStatement kernelStatement;
    @Mock
    private StatementOperationParts statementOperationParts;
    @Mock
    private SchemaReadOperations schemaReadOperations;
    @InjectMocks
    private OperationsFacade operationsFacade;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.operationsFacade.initialize(this.statementOperationParts);
    }

    @Test
    public void testThrowExceptionWhenIndexNotFoundByLabelAndProperty() throws SchemaRuleNotFoundException {
        this.setupSchemaReadOperations();
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(IndexSchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Index for label 'Label1' and property 'Prop1' not found."));
        this.operationsFacade.indexGetForLabelAndPropertyKey(1, 2);
    }

    @Test
    public void testThrowExceptionWhenDuplicateUniqueIndexFound() throws SchemaRuleNotFoundException, DuplicateIndexSchemaRuleException {
        SchemaReadOperations readOperations = this.setupSchemaReadOperations();
        Mockito.when((Object)readOperations.uniqueIndexesGetForLabel((KernelStatement)Mockito.any(KernelStatement.class), Mockito.eq((int)1))).thenReturn((Object)Iterators.iterator((Object[])new IndexDescriptor[]{new IndexDescriptor(1, 2), new IndexDescriptor(1, 2)}));
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(DuplicateIndexSchemaRuleException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Multiple uniqueness indexes found for label 'Label1' and property 'Prop1'."));
        this.operationsFacade.uniqueIndexGetForLabelAndPropertyKey(1, 2);
    }

    @Test
    public void testThrowExceptionWhenUniqueIndexNotFound() throws SchemaRuleNotFoundException, DuplicateIndexSchemaRuleException {
        SchemaReadOperations readOperations = this.setupSchemaReadOperations();
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        Mockito.when((Object)readOperations.uniqueIndexesGetForLabel((KernelStatement)Mockito.any(KernelStatement.class), Mockito.eq((int)1))).thenReturn((Object)Iterators.emptyIterator());
        this.expectedException.expect(IndexSchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Uniqueness index for label 'Label1' and property 'Prop1' not found."));
        this.operationsFacade.uniqueIndexGetForLabelAndPropertyKey(1, 2);
    }

    private SchemaReadOperations setupSchemaReadOperations() {
        SchemaReadOperations readOperations = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        Mockito.when((Object)this.statementOperationParts.schemaReadOperations()).thenReturn((Object)readOperations);
        return readOperations;
    }

    private TokenNameLookup getDefaultTokenNameLookup() {
        TokenNameLookup tokenNameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        Mockito.when((Object)tokenNameLookup.labelGetName(1)).thenReturn((Object)"Label1");
        Mockito.when((Object)tokenNameLookup.propertyKeyGetName(2)).thenReturn((Object)"Prop1");
        return tokenNameLookup;
    }
}

