/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class HalfAppliedConstraintRecoveryIT {
    private static final BiConsumer<GraphDatabaseAPI, List<TransactionRepresentation>> REAPPLY = (db, txs) -> HalfAppliedConstraintRecoveryIT.apply(db, txs.subList(txs.size() - 1, txs.size()));
    private static final BiConsumer<GraphDatabaseAPI, List<TransactionRepresentation>> RECREATE = (db, txs) -> HalfAppliedConstraintRecoveryIT.createConstraint(db);
    private static final Label LABEL = TestLabels.LABEL_ONE;
    private static final String KEY = "key";
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("T2");
    private final Monitors monitors = new Monitors();

    @Test
    public void recoverFromAndContinueApplyHalfConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromHalfConstraintAppliedBeforeCrash(REAPPLY);
    }

    @Test
    public void recoverFromAndRecreateHalfConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromHalfConstraintAppliedBeforeCrash(RECREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverFromHalfConstraintAppliedBeforeCrash(BiConsumer<GraphDatabaseAPI, List<TransactionRepresentation>> applier) throws Exception {
        EphemeralFileSystemAbstraction crashSnapshot;
        List<TransactionRepresentation> transactions = HalfAppliedConstraintRecoveryIT.createTransactionsForCreatingConstraint();
        GraphDatabaseAPI db = this.newDb();
        try {
            HalfAppliedConstraintRecoveryIT.apply(db, transactions.subList(0, transactions.size() - 1));
            HalfAppliedConstraintRecoveryIT.flushStores(db);
            crashSnapshot = this.fs.snapshot();
        }
        finally {
            db.shutdown();
        }
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)crashSnapshot).newImpermanentDatabase();
        try {
            applier.accept(db, transactions);
            try (Transaction tx = db.beginTx();){
                ConstraintDefinition constraint = (ConstraintDefinition)Iterables.single((Iterable)db.schema().getConstraints(LABEL));
                Assert.assertEquals((Object)LABEL.name(), (Object)constraint.getLabel().name());
                Assert.assertEquals((Object)KEY, (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
                IndexDefinition index = (IndexDefinition)Iterables.single((Iterable)db.schema().getIndexes(LABEL));
                Assert.assertEquals((Object)LABEL.name(), (Object)index.getLabel().name());
                Assert.assertEquals((Object)KEY, (Object)Iterables.single((Iterable)index.getPropertyKeys()));
                tx.success();
            }
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void recoverFromNonUniqueHalfConstraintAppliedBeforeCrash() throws Exception {
        EphemeralFileSystemAbstraction crashSnapshot;
        List<TransactionRepresentation> transactions = HalfAppliedConstraintRecoveryIT.createTransactionsForCreatingConstraint();
        GraphDatabaseAPI db = this.newDb();
        final Barrier.Control barrier = new Barrier.Control();
        this.monitors.addMonitorListener((Object)new IndexingService.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                barrier.reached();
            }
        }, new String[0]);
        try {
            String value = "v";
            try (Transaction tx = db.beginTx();){
                for (int i = 0; i < 2; ++i) {
                    db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)value);
                }
                tx.success();
            }
            this.t2.execute(state -> {
                HalfAppliedConstraintRecoveryIT.apply(db, transactions.subList(0, transactions.size() - 1));
                return null;
            });
            barrier.await();
            HalfAppliedConstraintRecoveryIT.flushStores(db);
            crashSnapshot = this.fs.snapshot();
            barrier.release();
        }
        finally {
            db.shutdown();
        }
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)crashSnapshot).newImpermanentDatabase();
        try {
            RECREATE.accept(db, transactions);
            Assert.fail((String)"Should not be able to create constraint on non-unique data");
        }
        catch (ConstraintViolationException constraintViolationException) {
        }
        finally {
            db.shutdown();
        }
    }

    private GraphDatabaseAPI newDb() {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs).setMonitors(this.monitors).newImpermanentDatabase();
    }

    private static void flushStores(GraphDatabaseAPI db) {
        ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().flush(IOLimiter.unlimited());
    }

    private static void apply(GraphDatabaseAPI db, List<TransactionRepresentation> transactions) {
        TransactionCommitProcess committer = (TransactionCommitProcess)db.getDependencyResolver().resolveDependency(TransactionCommitProcess.class);
        transactions.forEach(tx -> {
            try {
                committer.commit(new TransactionToApply(tx), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            }
            catch (TransactionFailureException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TransactionRepresentation> createTransactionsForCreatingConstraint() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            HalfAppliedConstraintRecoveryIT.createConstraint(db);
            LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
            ArrayList<TransactionRepresentation> transactions = new ArrayList<TransactionRepresentation>();
            try (TransactionCursor cursor = txStore.getTransactions(2L);){
                cursor.forAll(tx -> transactions.add(tx.getTransactionRepresentation()));
            }
            ArrayList<TransactionRepresentation> arrayList = transactions;
            return arrayList;
        }
        finally {
            db.shutdown();
        }
    }

    private static void createConstraint(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            db.schema().constraintFor(LABEL).assertPropertyIsUnique(KEY).create();
            tx.success();
        }
    }
}

