/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.test.DoubleLatch;

public class NodeGetUniqueFromIndexSeekIT
extends KernelIntegrationTest {
    private int labelId;
    private int propertyKeyId;

    @Before
    public void createKeys() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        this.labelId = statement.labelGetOrCreateForName("Person");
        this.propertyKeyId = statement.propertyKeyGetOrCreateForName("foo");
        this.commit();
    }

    @Test
    public void shouldFindMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint();
        String value = "value";
        long nodeId = this.createNodeWithValue(value);
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long foundId = statement.nodeGetFromUniqueIndexSeek(index, (Object)value);
        this.commit();
        Assert.assertTrue((String)"Created node was not found", (nodeId == foundId ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotFindNonMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint();
        String value = "value";
        this.createNodeWithValue("other_" + value);
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long foundId = statement.nodeGetFromUniqueIndexSeek(index, (Object)value);
        this.commit();
        Assert.assertTrue((String)"Non-matching created node was found", (boolean)this.isNoSuchNode(foundId));
    }

    @Test(timeout=1000L)
    public void shouldBlockUniqueIndexSeekFromCompetingTransaction() throws Exception {
        DoubleLatch latch = new DoubleLatch();
        DependencyResolver resolver = this.db.getDependencyResolver();
        Locks manager = (Locks)resolver.resolveDependency(Locks.class);
        IndexDescriptor index = this.createUniquenessConstraint();
        String value = "value";
        DataWriteOperations dataStatement = this.dataWriteOperationsInNewTransaction();
        long nodeId = dataStatement.nodeCreate();
        dataStatement.nodeAddLabel(nodeId, this.labelId);
        dataStatement.nodeSetProperty(nodeId, Property.stringProperty((int)this.propertyKeyId, (String)"value"));
        Runnable runnableForThread2 = () -> {
            latch.waitForAllToStart();
            try (Transaction tx = this.db.beginTx();){
                try (Statement statement1 = this.statementContextSupplier.get();){
                    statement1.readOperations().nodeGetFromUniqueIndexSeek(index, (Object)"value");
                }
                tx.success();
            }
            catch (IndexNotFoundKernelException | IndexBrokenKernelException e) {
                throw new RuntimeException(e);
            }
            finally {
                latch.finish();
            }
        };
        Thread thread2 = new Thread(runnableForThread2, "Transaction Thread 2");
        thread2.start();
        latch.startAndWaitForAllToStart();
        while (thread2.getState() != Thread.State.TIMED_WAITING && thread2.getState() != Thread.State.WAITING) {
            Thread.yield();
        }
        this.commit();
        latch.waitForAllToFinish();
    }

    private boolean isNoSuchNode(long foundId) {
        return -1L == foundId;
    }

    private long createNodeWithValue(String value) throws KernelException {
        DataWriteOperations dataStatement = this.dataWriteOperationsInNewTransaction();
        long nodeId = dataStatement.nodeCreate();
        dataStatement.nodeAddLabel(nodeId, this.labelId);
        dataStatement.nodeSetProperty(nodeId, Property.stringProperty((int)this.propertyKeyId, (String)value));
        this.commit();
        return nodeId;
    }

    private IndexDescriptor createUniquenessConstraint() throws Exception {
        SchemaWriteOperations schemaStatement = this.schemaWriteOperationsInNewTransaction();
        schemaStatement.uniquePropertyConstraintCreate(this.labelId, this.propertyKeyId);
        IndexDescriptor result = schemaStatement.uniqueIndexGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId);
        this.commit();
        return result;
    }
}

