/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.LongStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.store.StoreLabelCursor;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.StandaloneDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class StoreLabelCursorTest {
    @Test
    public void readNoLabels() {
        StoreLabelCursor cursor = StoreLabelCursorTest.newCursor();
        NodeRecord node = new NodeRecord(1L).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        cursor.init(node);
        Assert.assertFalse((boolean)cursor.next());
    }

    @Test
    public void readInlinedLabels() {
        long[] labels = new long[]{1L, 2L, 42L};
        NodeRecord node = new NodeRecord(1L).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        Collection allocatedDynamicRecords = InlineNodeLabels.putSorted((NodeRecord)node, (long[])labels, null, null);
        Assert.assertThat((Object)allocatedDynamicRecords, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        StoreLabelCursor cursor = StoreLabelCursorTest.newCursor();
        cursor.init(node);
        StoreLabelCursorTest.verifyCursor(labels, cursor);
    }

    @Test
    public void readDynamicLabels() {
        long[] labels = LongStream.iterate(1L, id -> id + 2L).limit(1000L).toArray();
        NodeRecord node = new NodeRecord(1L).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        Collection allocatedDynamicRecords = DynamicNodeLabels.putSorted((NodeRecord)node, (long[])labels, (NodeStore)((NodeStore)Mockito.mock(NodeStore.class)), (DynamicRecordAllocator)new StandaloneDynamicRecordAllocator());
        for (DynamicRecord dynamicRecord : allocatedDynamicRecords) {
            dynamicRecord.setInUse(true);
        }
        node.setLabelField(node.getLabelField(), Collections.emptyList());
        Assert.assertThat((Object)allocatedDynamicRecords, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        StoreLabelCursor cursor = StoreLabelCursorTest.newCursor(allocatedDynamicRecords);
        cursor.init(node);
        StoreLabelCursorTest.verifyCursor(labels, cursor);
    }

    private static void verifyCursor(long[] expectedLabels, StoreLabelCursor cursor) {
        for (long label : expectedLabels) {
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)label, (long)cursor.getAsInt());
        }
        Assert.assertFalse((boolean)cursor.next());
    }

    private static StoreLabelCursor newCursor(Collection<DynamicRecord> recordsForRecordCursor) {
        RecordCursor recordCursor = (RecordCursor)Mockito.mock(RecordCursor.class);
        Mockito.when((Object)recordCursor.getAll()).thenReturn((Object)Iterables.asList(recordsForRecordCursor));
        return new StoreLabelCursor(recordCursor, cursor -> {});
    }

    private static StoreLabelCursor newCursor() {
        return new StoreLabelCursor((RecordCursor)Mockito.mock(RecordCursor.class), cursor -> {});
    }
}

