/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestConcurrentRelationshipChainLoadingIssue {
    private final int relCount = 2;

    @Test
    public void tryToTriggerRelationshipLoadingStoppingMidWay() throws Throwable {
        this.tryToTriggerRelationshipLoadingStoppingMidWay(50);
    }

    @Test
    public void tryToTriggerRelationshipLoadingStoppingMidWayForDenseNodeRepresentation() throws Throwable {
        this.tryToTriggerRelationshipLoadingStoppingMidWay(1);
    }

    private void tryToTriggerRelationshipLoadingStoppingMidWay(int denseNodeThreshold) throws Throwable {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.dense_node_threshold, "" + denseNodeThreshold).newGraphDatabase();
        Node node = this.createNodeWithRelationships(db);
        this.checkStateToHelpDiagnoseFlakeyTest(db, node);
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        for (int iterations = 0; System.currentTimeMillis() < end && iterations < 100; ++iterations) {
            this.tryOnce(db, node);
        }
        db.shutdown();
    }

    private void checkStateToHelpDiagnoseFlakeyTest(GraphDatabaseAPI db, Node node) {
        this.loadNode(db, node);
        this.loadNode(db, node);
    }

    private void loadNode(GraphDatabaseAPI db, Node node) {
        try (Transaction ignored = db.beginTx();){
            Iterables.count((Iterable)node.getRelationships());
        }
    }

    private void tryOnce(GraphDatabaseAPI db, Node node) throws Throwable {
        Race race = new Race().withRandomStartDelays();
        race.addContestants(Runtime.getRuntime().availableProcessors(), () -> {
            try (Transaction ignored = db.beginTx();){
                Assert.assertEquals((long)2L, (long)Iterables.count((Iterable)node.getRelationships()));
            }
        });
        race.go();
    }

    private Node createNodeWithRelationships(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            int i;
            Node node = db.createNode();
            for (i = 0; i < 1; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            }
            for (i = 0; i < 1; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST2);
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }
}

