/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.Token;
import org.neo4j.string.UTF8;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.test.rule.NeoStoreDataSourceRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class NeoStoresTest {
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final ExpectedException exception = ExpectedException.none();
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory dir = TestDirectory.testDirectory((FileSystemAbstraction)this.fs.get());
    private final NeoStoreDataSourceRule dsRule = new NeoStoreDataSourceRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.exception).around((TestRule)this.pageCacheRule).around((TestRule)this.fs).around((TestRule)this.dir).around((TestRule)this.dsRule);
    private PageCache pageCache;
    private File storeDir;
    private PropertyStore pStore;
    private RelationshipTypeTokenStore rtStore;
    private NeoStoreDataSource ds;
    private KernelTransaction tx;
    private TransactionState transaction;
    private StoreReadLayer storeLayer;
    private PropertyLoader propertyLoader;

    @Before
    public void setUpNeoStores() throws Exception {
        this.storeDir = this.dir.graphDbDir();
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get());
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCache, (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        sf.openAllNeoStores(true).close();
    }

    @Test
    public void impossibleToGetStoreFromClosedNeoStoresContainer() {
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCache, (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = sf.openAllNeoStores(true);
        Assert.assertNotNull((Object)neoStores.getMetaDataStore());
        neoStores.close();
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Specified store was already closed.");
        neoStores.getMetaDataStore();
    }

    @Test
    public void notAllowCreateDynamicStoreWithNegativeBlockSize() {
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCache, (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Block size of dynamic array store should be positive integer.");
        try (NeoStores neoStores = sf.openNeoStores(true, new StoreType[0]);){
            neoStores.createDynamicArrayStore("someStore", IdType.ARRAY_BLOCK, -2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void impossibleToGetNotRequestedStore() {
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCache, (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = sf.openNeoStores(true, new StoreType[]{StoreType.NODE_LABEL});
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Specified store was not initialized. Please specify " + StoreType.META_DATA.name() + " as one of the stores types that should be open to be able to use it.");
        try {
            neoStores.getMetaDataStore();
        }
        finally {
            neoStores.close();
        }
    }

    @Test
    public void testCreateStore() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        long node1 = this.nextId(Node.class);
        this.transaction.nodeDoCreate(node1);
        long node2 = this.nextId(Node.class);
        this.transaction.nodeDoCreate(node2);
        DefinedProperty n1prop1 = this.nodeAddProperty(node1, this.index("prop1"), "string1");
        DefinedProperty n1prop2 = this.nodeAddProperty(node1, this.index("prop2"), 1);
        DefinedProperty n1prop3 = this.nodeAddProperty(node1, this.index("prop3"), true);
        DefinedProperty n2prop1 = this.nodeAddProperty(node2, this.index("prop1"), "string2");
        DefinedProperty n2prop2 = this.nodeAddProperty(node2, this.index("prop2"), 2);
        DefinedProperty n2prop3 = this.nodeAddProperty(node2, this.index("prop3"), false);
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName1 = "relationshiptype1";
        this.transaction.relationshipTypeDoCreateForName(typeName1, relType1);
        int relType2 = (int)this.nextId(RelationshipType.class);
        String typeName2 = "relationshiptype2";
        this.transaction.relationshipTypeDoCreateForName(typeName2, relType2);
        long rel1 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel1, relType1, node1, node2);
        long rel2 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel2, relType2, node2, node1);
        DefinedProperty r1prop1 = this.relAddProperty(rel1, this.index("prop1"), "string1");
        DefinedProperty r1prop2 = this.relAddProperty(rel1, this.index("prop2"), 1);
        DefinedProperty r1prop3 = this.relAddProperty(rel1, this.index("prop3"), true);
        DefinedProperty r2prop1 = this.relAddProperty(rel2, this.index("prop1"), "string2");
        DefinedProperty r2prop2 = this.relAddProperty(rel2, this.index("prop2"), 2);
        DefinedProperty r2prop3 = this.relAddProperty(rel2, this.index("prop3"), false);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.validateNodeRel1(node1, n1prop1, n1prop2, n1prop3, rel1, rel2, relType1, relType2);
        this.validateNodeRel2(node2, n2prop1, n2prop2, n2prop3, rel1, rel2, relType1, relType2);
        this.validateRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.validateRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.deleteRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.deleteRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.deleteNode1(node1, n1prop1, n1prop2, n1prop3);
        this.deleteNode2(node2, n2prop1, n2prop2, n2prop3);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        Assert.assertFalse((boolean)this.nodeExists(node1));
        Assert.assertFalse((boolean)this.nodeExists(node2));
        this.testGetRels(new long[]{rel1, rel2});
        long[] nodeIds = new long[10];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            long id = this.nextId(Relationship.class);
            this.transaction.relationshipDoCreate(id, relType1, nodeIds[i], nodeIds[i + 1]);
            this.transaction.relationshipDoDelete(id, relType1, nodeIds[i], nodeIds[i + 1]);
        }
        for (i = 0; i < 3; ++i) {
            this.transaction.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    private DefinedProperty nodeAddProperty(long nodeId, int key, Object value) {
        DefinedProperty property = Property.property((int)key, (Object)value);
        Property oldProperty = Property.noNodeProperty((long)nodeId, (int)key);
        try (StorageStatement statement = this.storeLayer.newStatement();
             Cursor cursor = statement.acquireSingleNodeCursor(nodeId, AssertOpen.ALWAYS_OPEN);){
            Object oldValue;
            if (cursor.next() && (oldValue = ((NodeItem)cursor.get()).getProperty(key)) != null) {
                oldProperty = Property.property((int)key, (Object)oldValue);
            }
        }
        this.transaction.nodeDoReplaceProperty(nodeId, oldProperty, property);
        return property;
    }

    private DefinedProperty relAddProperty(long relationshipId, int key, Object value) {
        DefinedProperty property = Property.property((int)key, (Object)value);
        Property oldProperty = Property.noRelationshipProperty((long)relationshipId, (int)key);
        try (StorageStatement statement = this.storeLayer.newStatement();
             Cursor cursor = statement.acquireSingleRelationshipCursor(relationshipId, AssertOpen.ALWAYS_OPEN);){
            Object oldValue;
            if (cursor.next() && (oldValue = ((RelationshipItem)cursor.get()).getProperty(key)) != null) {
                oldProperty = Property.property((int)key, (Object)oldValue);
            }
        }
        this.transaction.relationshipDoReplaceProperty(relationshipId, oldProperty, property);
        return property;
    }

    @Test
    public void testRels1() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transaction.relationshipTypeDoCreateForName(typeName, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            this.transaction.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            this.deleteRelationships(nodeIds[i]);
            this.transaction.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    private void relDelete(long id) throws Exception {
        RelationshipVisitor<RuntimeException> visitor = new RelationshipVisitor<RuntimeException>(){

            public void visit(long relId, int type, long startNode, long endNode) {
                NeoStoresTest.this.transaction.relationshipDoDelete(relId, type, startNode, endNode);
            }
        };
        if (!this.transaction.relationshipVisit(id, (RelationshipVisitor)visitor)) {
            this.storeLayer.relationshipVisit(id, (RelationshipVisitor)visitor);
        }
    }

    @Test
    public void testRels2() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transaction.relationshipTypeDoCreateForName(typeName, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            this.transaction.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.transaction.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[0], nodeIds[2]);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            this.deleteRelationships(nodeIds[i]);
            this.transaction.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testRels3() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        this.transaction.relationshipTypeDoCreateForName("relationshiptype1", relType1);
        long[] nodeIds = new long[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeDoCreate(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.transaction.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i * 2]);
        }
        long rel5 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel5, relType1, nodeIds[0], nodeIds[5]);
        long rel2 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel2, relType1, nodeIds[1], nodeIds[2]);
        long rel3 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel3, relType1, nodeIds[1], nodeIds[3]);
        long rel6 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel6, relType1, nodeIds[1], nodeIds[6]);
        long rel1 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel1, relType1, nodeIds[0], nodeIds[1]);
        long rel4 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel4, relType1, nodeIds[0], nodeIds[4]);
        long rel7 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel7, relType1, nodeIds[0], nodeIds[7]);
        this.commitTx();
        this.startTx();
        this.relDelete(rel7);
        this.relDelete(rel4);
        this.relDelete(rel1);
        this.relDelete(rel6);
        this.relDelete(rel3);
        this.relDelete(rel2);
        this.relDelete(rel5);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testProps1() throws Exception {
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        long nodeId = this.nextId(Node.class);
        this.transaction.nodeDoCreate(nodeId);
        this.pStore.nextId();
        DefinedProperty prop = this.nodeAddProperty(nodeId, this.index("nisse"), 10);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        DefinedProperty prop2 = this.nodeAddProperty(nodeId, prop.propertyKeyId(), 5);
        this.transaction.nodeDoRemoveProperty(nodeId, prop2);
        this.transaction.nodeDoDelete(nodeId);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testSetBlockSize() throws Exception {
        File storeDir = this.dir.directory("small_store");
        this.initializeStores(storeDir, MapUtil.stringMap((String[])new String[]{"unsupported.dbms.block_size.strings", "62", "unsupported.dbms.block_size.array_properties", "302"}));
        Assert.assertEquals((long)70L, (long)this.pStore.getStringStore().getRecordSize());
        Assert.assertEquals((long)310L, (long)this.pStore.getArrayStore().getRecordSize());
        this.ds.stop();
    }

    @Test
    public void setVersion() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File storeDir = new File("target/test-data/set-version").getAbsoluteFile();
        new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).newImpermanentDatabase(storeDir).shutdown();
        Assert.assertEquals((long)0L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)new File(storeDir, "neostore").getAbsoluteFile(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)10L));
        Assert.assertEquals((long)10L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)new File(storeDir, "neostore").getAbsoluteFile(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)12L));
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fileSystem), this.pageCache, (FileSystemAbstraction)fileSystem, (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = sf.openAllNeoStores();
        Assert.assertEquals((long)12L, (long)neoStores.getMetaDataStore().getCurrentLogVersion());
        neoStores.close();
    }

    @Test
    public void shouldNotReadNonRecordDataAsRecord() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = new File("/tmp/graph.db/neostore").getAbsoluteFile();
        StoreFactory factory = NeoStoresTest.newStoreFactory(neoStoreDir, this.pageCache, (FileSystemAbstraction)fileSystem);
        long recordVersion = NeoStoresTest.defaultStoreVersion();
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            metaDataStore.setCreationTime(3L);
            metaDataStore.setRandomNumber(4L);
            metaDataStore.setCurrentLogVersion(5L);
            metaDataStore.setLastCommittedAndClosedTransactionId(6L, 0L, 0L, 43L, 44L);
            metaDataStore.setStoreVersion(recordVersion);
            metaDataStore.setGraphNextProp(8L);
            metaDataStore.setLatestConstraintIntroducingTx(9L);
        }
        File file = new File(neoStoreDir, "neostore");
        try (StoreChannel channel = fileSystem.open(file, "rw");){
            channel.position(0L);
            channel.write(ByteBuffer.wrap(UTF8.encode((String)"This is some data that is not a record.")));
        }
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)recordVersion);
        var8_7 = null;
        try (NeoStores neoStores = factory.openAllNeoStores();){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            Assert.assertEquals((long)-1L, (long)metaDataStore.getCreationTime());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getRandomNumber());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getCurrentLogVersion());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getLastCommittedTransactionId());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getLastClosedTransactionId());
            Assert.assertEquals((long)recordVersion, (long)metaDataStore.getStoreVersion());
            Assert.assertEquals((long)8L, (long)metaDataStore.getGraphNextProp());
            Assert.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assert.assertArrayEquals((long[])metaDataStore.getLastClosedTransaction(), (long[])new long[]{-1L, 44L, 43L});
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSetLatestConstraintTx() throws Exception {
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(this.dir.directory(), config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = sf.openAllNeoStores(true);
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        Assert.assertEquals((long)0L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        metaDataStore.setLatestConstraintIntroducingTx(10L);
        Assert.assertEquals((long)10L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        neoStores.flush(IOLimiter.unlimited());
        neoStores.close();
        neoStores = sf.openAllNeoStores();
        Assert.assertEquals((long)10L, (long)neoStores.getMetaDataStore().getLatestConstraintIntroducingTx());
        neoStores.close();
    }

    @Test
    public void shouldInitializeTheTxIdToOne() {
        StoreFactory factory = new StoreFactory(new File("graph.db/neostore"), this.pageCache, (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        neoStores = factory.openAllNeoStores();
        var3_3 = null;
        try {
            long lastCommittedTransactionId = neoStores.getMetaDataStore().getLastCommittedTransactionId();
            Assert.assertEquals((long)1L, (long)lastCommittedTransactionId);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (neoStores != null) {
                if (var3_3 != null) {
                    try {
                        neoStores.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    neoStores.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowUnderlyingStorageExceptionWhenFailingToLoadStorage() {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = new File("/tmp/graph.db/neostore").getAbsoluteFile();
        StoreFactory factory = new StoreFactory(neoStoreDir, this.pageCache, (FileSystemAbstraction)fileSystem, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        File file = new File(neoStoreDir, "neostore");
        fileSystem.deleteFile(file);
        this.exception.expect(StoreNotFoundException.class);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            neoStores.getMetaDataStore();
        }
    }

    @Test
    public void shouldAddUpgradeFieldsToTheNeoStoreIfNotPresent() throws IOException {
        MetaDataStore metaDataStore;
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = new File("/tmp/graph.db/neostore").getAbsoluteFile();
        StoreFactory factory = NeoStoresTest.newStoreFactory(neoStoreDir, this.pageCache, (FileSystemAbstraction)fileSystem);
        long recordVersion = NeoStoresTest.defaultStoreVersion();
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore2 = neoStores.getMetaDataStore();
            metaDataStore2.setCreationTime(3L);
            metaDataStore2.setRandomNumber(4L);
            metaDataStore2.setCurrentLogVersion(5L);
            metaDataStore2.setLastCommittedAndClosedTransactionId(6L, 42L, 0L, 43L, 44L);
            metaDataStore2.setStoreVersion(recordVersion);
            metaDataStore2.setGraphNextProp(8L);
            metaDataStore2.setLatestConstraintIntroducingTx(9L);
        }
        File file = new File(neoStoreDir, "neostore");
        Assert.assertNotEquals((long)10L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID));
        Assert.assertNotEquals((long)11L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM));
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID, (long)10L);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, (long)11L);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TIME, (long)12L);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            metaDataStore = neoStores.getMetaDataStore();
            Assert.assertEquals((long)3L, (long)metaDataStore.getCreationTime());
            Assert.assertEquals((long)4L, (long)metaDataStore.getRandomNumber());
            Assert.assertEquals((long)5L, (long)metaDataStore.getCurrentLogVersion());
            Assert.assertEquals((long)6L, (long)metaDataStore.getLastCommittedTransactionId());
            Assert.assertEquals((long)recordVersion, (long)metaDataStore.getStoreVersion());
            Assert.assertEquals((long)8L, (long)metaDataStore.getGraphNextProp());
            Assert.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assert.assertEquals((Object)new TransactionId(10L, 11L, 0L), (Object)metaDataStore.getUpgradeTransaction());
            Assert.assertEquals((long)12L, (long)metaDataStore.getUpgradeTime());
            Assert.assertArrayEquals((long[])metaDataStore.getLastClosedTransaction(), (long[])new long[]{6L, 44L, 43L});
        }
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, (long)13L);
        neoStores = factory.openAllNeoStores();
        var8_7 = null;
        try {
            metaDataStore = neoStores.getMetaDataStore();
            Assert.assertEquals((Object)new TransactionId(10L, 11L, 13L), (Object)metaDataStore.getUpgradeTransaction());
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (neoStores != null) {
                if (var8_7 != null) {
                    try {
                        neoStores.close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    neoStores.close();
                }
            }
        }
    }

    @Test
    public void shouldSetHighestTransactionIdWhenNeeded() throws Throwable {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.mkdirs(this.storeDir);
        StoreFactory factory = new StoreFactory(this.storeDir, this.pageCache, (FileSystemAbstraction)fileSystem, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444L, 0L, 16L, 0L);
            store.transactionCommitted(42L, 6666L, 0L);
            Assert.assertEquals((Object)new TransactionId(42L, 6666L, 0L), (Object)store.getLastCommittedTransaction());
            Assert.assertArrayEquals((long[])store.getLastClosedTransaction(), (long[])new long[]{40L, 0L, 16L});
        }
    }

    @Test
    public void shouldNotSetHighestTransactionIdWhenNeeded() throws Throwable {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.mkdirs(this.storeDir);
        StoreFactory factory = new StoreFactory(this.storeDir, this.pageCache, (FileSystemAbstraction)fileSystem, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444L, 0L, 16L, 0L);
            store.transactionCommitted(39L, 3333L, 0L);
            Assert.assertEquals((Object)new TransactionId(40L, 4444L, 0L), (Object)store.getLastCommittedTransaction());
            Assert.assertArrayEquals((long[])store.getLastClosedTransaction(), (long[])new long[]{40L, 0L, 16L});
        }
    }

    @Test
    public void shouldCloseAllTheStoreEvenIfExceptionsAreThrown() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        Config defaults = Config.defaults().with(Collections.singletonMap(GraphDatabaseSettings.counts_store_rotation_timeout.name(), "60m"), new Class[0]);
        StoreFactory factory = new StoreFactory(this.storeDir, defaults, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fileSystem), this.pageCache, (FileSystemAbstraction)fileSystem, (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStore = factory.openAllNeoStores(true);
        CountsTracker counts = neoStore.getCounts();
        counts.start();
        long nextTxId = neoStore.getMetaDataStore().getLastCommittedTransactionId() + 1L;
        AtomicReference exRef = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                counts.rotate(nextTxId);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Throwable e) {
                exRef.set(e);
                throw new RuntimeException(e);
            }
        });
        thread.start();
        ThreadTestUtils.awaitThreadState((Thread)thread, (long)500L, (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[]{Thread.State.WAITING});
        try {
            neoStore.close();
            Assert.fail((String)"should have thrown");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Cannot stop in state: rotating", (Object)ex.getMessage());
        }
        thread.interrupt();
        thread.join();
        this.pageCache.close();
        Assert.assertNull(exRef.get());
    }

    private static long defaultStoreVersion() {
        return MetaDataStore.versionStringToLong((String)RecordFormatSelector.defaultFormat().storeVersion());
    }

    private static StoreFactory newStoreFactory(File neoStoreDir, PageCache pageCache, FileSystemAbstraction fs) {
        return new StoreFactory(neoStoreDir, pageCache, fs, RecordFormatSelector.defaultFormat(), (LogProvider)NullLogProvider.getInstance());
    }

    private Token createDummyIndex(int id, String key) {
        MyPropertyKeyToken index = new MyPropertyKeyToken(key, id);
        MyPropertyKeyToken.add(index);
        return index;
    }

    private void initializeStores(File storeDir, Map<String, String> additionalConfig) throws IOException {
        this.ds = this.dsRule.getDataSource(storeDir, (FileSystemAbstraction)this.fs.get(), this.pageCache, additionalConfig);
        this.ds.init();
        this.ds.start();
        NeoStores neoStores = ((RecordStorageEngine)this.ds.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.pStore = neoStores.getPropertyStore();
        this.rtStore = neoStores.getRelationshipTypeTokenStore();
        this.storeLayer = this.ds.getStoreLayer();
        this.propertyLoader = new PropertyLoader(neoStores);
    }

    private void startTx() throws TransactionFailureException {
        this.tx = this.ds.getKernel().newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
        this.transaction = ((KernelTransactionImplementation)this.tx).txState();
    }

    private void commitTx() throws TransactionFailureException {
        this.tx.success();
        this.tx.close();
    }

    private int index(String key) {
        Iterator<Token> itr = MyPropertyKeyToken.index(key).iterator();
        if (!itr.hasNext()) {
            int id = (int)this.nextId(PropertyKeyTokenRecord.class);
            this.createDummyIndex(id, key);
            this.transaction.propertyKeyDoCreateForName(key, id);
            return id;
        }
        return itr.next().id();
    }

    private long nextId(Class<?> clazz) {
        NeoStores neoStores = ((RecordStorageEngine)this.ds.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        if (clazz.equals(PropertyKeyTokenRecord.class)) {
            return neoStores.getPropertyKeyTokenStore().nextId();
        }
        if (clazz.equals(RelationshipType.class)) {
            return neoStores.getRelationshipTypeTokenStore().nextId();
        }
        if (clazz.equals(Node.class)) {
            return neoStores.getNodeStore().nextId();
        }
        if (clazz.equals(Relationship.class)) {
            return neoStores.getRelationshipStore().nextId();
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    private void validateNodeRel1(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException {
        Assert.assertTrue((boolean)this.nodeExists(node));
        ArrayMap props = new ArrayMap();
        TransactionRecordState.PropertyReceiver<DefinedProperty> receiver = this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props);
        this.propertyLoader.nodeLoadProperties(node, receiver);
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)this.pStore, (long)id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value());
                this.nodeAddProperty(node, prop1.propertyKeyId(), "-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value());
                this.nodeAddProperty(node, prop2.propertyKeyId(), -1);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.nodeAddProperty(node, prop3.propertyKeyId(), false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = this.validateAndCountRelationships(node, rel1, rel2, relType1, relType2);
        Assert.assertEquals((long)2L, (long)count);
    }

    private int validateAndCountRelationships(long node, long rel1, long rel2, int relType1, int relType2) throws IOException {
        int count = 0;
        try (KernelStatement statement = (KernelStatement)this.tx.acquireStatement();
             Cursor nodeCursor = statement.getStoreStatement().acquireSingleNodeCursor(node, (AssertOpen)statement);){
            nodeCursor.next();
            try (Cursor relationships = ((NodeItem)nodeCursor.get()).relationships(Direction.BOTH);){
                while (relationships.next()) {
                    long rel = ((RelationshipItem)relationships.get()).id();
                    if (rel == rel1) {
                        Assert.assertEquals((long)node, (long)((RelationshipItem)relationships.get()).startNode());
                        Assert.assertEquals((long)relType1, (long)((RelationshipItem)relationships.get()).type());
                    } else if (rel == rel2) {
                        Assert.assertEquals((long)node, (long)((RelationshipItem)relationships.get()).endNode());
                        Assert.assertEquals((long)relType2, (long)((RelationshipItem)relationships.get()).type());
                    } else {
                        throw new IOException();
                    }
                    ++count;
                }
            }
        }
        return count;
    }

    private TransactionRecordState.PropertyReceiver<DefinedProperty> newPropertyReceiver(ArrayMap<Integer, Pair<DefinedProperty, Long>> props) {
        return (property, propertyRecordId) -> props.put((Object)property.propertyKeyId(), (Object)Pair.of((Object)property, (Object)propertyRecordId));
    }

    private void validateNodeRel2(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException, RuntimeException {
        Assert.assertTrue((boolean)this.nodeExists(node));
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)this.pStore, (long)id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value());
                this.nodeAddProperty(node, prop1.propertyKeyId(), "-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value());
                this.nodeAddProperty(node, prop2.propertyKeyId(), -2);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.nodeAddProperty(node, prop3.propertyKeyId(), true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        try (KernelStatement statement = (KernelStatement)this.tx.acquireStatement();
             Cursor nodeCursor = statement.getStoreStatement().acquireSingleNodeCursor(node, (AssertOpen)statement);){
            nodeCursor.next();
            try (Cursor relationships = ((NodeItem)nodeCursor.get()).relationships(Direction.BOTH);){
                while (relationships.next()) {
                    long rel = ((RelationshipItem)relationships.get()).id();
                    if (rel == rel1) {
                        Assert.assertEquals((long)node, (long)((RelationshipItem)relationships.get()).endNode());
                        Assert.assertEquals((long)relType1, (long)((RelationshipItem)relationships.get()).type());
                    } else if (rel == rel2) {
                        Assert.assertEquals((long)node, (long)((RelationshipItem)relationships.get()).startNode());
                        Assert.assertEquals((long)relType2, (long)((RelationshipItem)relationships.get()).type());
                    } else {
                        throw new IOException();
                    }
                    ++count;
                }
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    /*
     * Exception decompiling
     */
    private boolean nodeExists(long nodeId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateRel1(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)this.pStore, (long)id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value());
                this.relAddProperty(rel, prop1.propertyKeyId(), "-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value());
                this.relAddProperty(rel, prop2.propertyKeyId(), -1);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.relAddProperty(rel, prop3.propertyKeyId(), false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void assertRelationshipData(long rel, final long firstNode, final long secondNode, final int relType) {
        try {
            this.storeLayer.relationshipVisit(rel, (RelationshipVisitor)new RelationshipVisitor<RuntimeException>(){

                public void visit(long relId, int type, long startNode, long endNode) {
                    Assert.assertEquals((long)firstNode, (long)startNode);
                    Assert.assertEquals((long)secondNode, (long)endNode);
                    Assert.assertEquals((long)relType, (long)type);
                }
            });
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateRel2(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)this.pStore, (long)id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value());
                this.relAddProperty(rel, prop1.propertyKeyId(), "-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value());
                this.relAddProperty(rel, prop2.propertyKeyId(), -2);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.relAddProperty(rel, prop3.propertyKeyId(), true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void validateRelTypes(int relType1, int relType2) throws IOException {
        Token data = this.rtStore.getToken(relType1);
        Assert.assertEquals((long)relType1, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype1", (Object)data.name());
        data = this.rtStore.getToken(relType2);
        Assert.assertEquals((long)relType2, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype2", (Object)data.name());
        List allData = this.rtStore.getTokens(Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)allData.size());
        for (int i = 0; i < 2; ++i) {
            if (((RelationshipTypeToken)allData.get(i)).id() == relType1) {
                Assert.assertEquals((long)relType1, (long)((RelationshipTypeToken)allData.get(i)).id());
                Assert.assertEquals((Object)"relationshiptype1", (Object)((RelationshipTypeToken)allData.get(i)).name());
                continue;
            }
            if (((RelationshipTypeToken)allData.get(i)).id() == relType2) {
                Assert.assertEquals((long)relType2, (long)((RelationshipTypeToken)allData.get(i)).id());
                Assert.assertEquals((Object)"relationshiptype2", (Object)((RelationshipTypeToken)allData.get(i)).name());
                continue;
            }
            throw new IOException();
        }
    }

    private void deleteRel1(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws Exception {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.relationshipDoRemoveProperty(rel, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.relLoadProperties(rel, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.relDelete(rel);
        this.assertHasRelationships(firstNode);
        this.assertHasRelationships(secondNode);
    }

    private void deleteRel2(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws Exception {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.relationshipDoRemoveProperty(rel, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.relLoadProperties(rel, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.relDelete(rel);
        this.assertHasRelationships(firstNode);
        this.assertHasRelationships(secondNode);
    }

    private void assertHasRelationships(long node) {
        try (KernelStatement statement = (KernelStatement)this.tx.acquireStatement();
             Cursor nodeCursor = statement.getStoreStatement().acquireSingleNodeCursor(node, (AssertOpen)statement);){
            nodeCursor.next();
            RelationshipIterator rels = ((NodeItem)nodeCursor.get()).getRelationships(Direction.BOTH);
            Assert.assertTrue((boolean)rels.hasNext());
        }
    }

    private void deleteNode1(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.nodeDoRemoveProperty(node, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.nodeLoadProperties(node, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertHasRelationships(node);
        this.transaction.nodeDoDelete(node);
    }

    private void deleteNode2(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.nodeDoRemoveProperty(node, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.nodeLoadProperties(node, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertHasRelationships(node);
        this.transaction.nodeDoDelete(node);
    }

    private void testGetRels(long[] relIds) {
        try (StorageStatement statement = this.storeLayer.newStatement();){
            for (long relId : relIds) {
                try (Cursor relationship = statement.acquireSingleRelationshipCursor(relId, AssertOpen.ALWAYS_OPEN);){
                    Assert.assertFalse((boolean)relationship.next());
                }
            }
        }
    }

    private void deleteRelationships(long nodeId) throws Exception {
        try (KernelStatement statement = (KernelStatement)this.tx.acquireStatement();
             Cursor nodeCursor = statement.getStoreStatement().acquireSingleNodeCursor(nodeId, (AssertOpen)statement);){
            nodeCursor.next();
            RelationshipIterator relationships = ((NodeItem)nodeCursor.get()).getRelationships(Direction.BOTH);
            while (relationships.hasNext()) {
                this.relDelete(relationships.next());
            }
        }
    }

    private static class CountingPropertyReceiver
    implements TransactionRecordState.PropertyReceiver<DefinedProperty> {
        private int count;

        private CountingPropertyReceiver() {
        }

        public void receive(DefinedProperty property, long propertyRecordId) {
            ++this.count;
        }
    }

    private static class MyPropertyKeyToken
    extends Token {
        private static Map<String, Token> stringToIndex = new HashMap<String, Token>();
        private static Map<Integer, Token> intToIndex = new HashMap<Integer, Token>();

        protected MyPropertyKeyToken(String key, int keyId) {
            super(key, keyId);
        }

        public static Iterable<Token> index(String key) {
            if (stringToIndex.containsKey(key)) {
                return Collections.singletonList(stringToIndex.get(key));
            }
            return Collections.emptyList();
        }

        public static Token getIndexFor(int index) {
            return intToIndex.get(index);
        }

        public static void add(MyPropertyKeyToken index) {
            stringToIndex.put(index.name(), index);
            intToIndex.put(index.id(), index);
        }
    }
}

