/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.IOFunction;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.CountsOracle;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.FileVersion;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.RotationTimeoutException;
import org.neo4j.kernel.impl.util.DebugUtil;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.Barrier;
import org.neo4j.test.rule.Resources;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class CountsTrackerTest {
    @Rule
    public final Resources resourceManager = new Resources(Resources.TestPath.FILE_IN_EXISTING_DIRECTORY);
    @Rule
    public final ThreadingRule threading = new ThreadingRule();

    @Test
    public void shouldBeAbleToStartAndStopTheStore() throws Exception {
        this.resourceManager.managed(this.newTracker());
        this.resourceManager.lifeStarts();
        this.resourceManager.lifeShutsDown();
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldBeAbleToWriteDataToCountsTracker() throws Exception {
        CountsTracker tracker = this.resourceManager.managed(this.newTracker());
        CountsOracle oracle = new CountsOracle();
        CountsOracle.Node a = oracle.node(1L);
        CountsOracle.Node b = oracle.node(1L);
        oracle.relationship(a, 1, b);
        oracle.indexSampling(1, 1, 2L, 2L);
        oracle.indexUpdatesAndSize(1, 1, 10L, 2L);
        oracle.update(tracker, 2L);
        oracle.verify(tracker);
        tracker.rotate(2L);
        oracle.verify(tracker);
        try (CountsAccessor.IndexStatsUpdater updater = tracker.updateIndexCounts();){
            updater.incrementIndexUpdates(1, 1, 2L);
        }
        oracle.indexUpdatesAndSize(1, 1, 12L, 2L);
        oracle.verify(tracker);
        tracker.rotate(2L);
        oracle.verify(tracker);
    }

    @Test
    public void shouldStoreCounts() throws Exception {
        CountsOracle oracle = this.someData();
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker tracker = (CountsTracker)life.add((Lifecycle)this.newTracker());
            oracle.update(tracker, 2L);
            tracker.rotate(2L);
        }
        life = new Lifespan(new Lifecycle[0]);
        var3_3 = null;
        try {
            oracle.verify((CountsVisitor.Visitable)life.add((Lifecycle)this.newTracker()));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (life != null) {
                if (var3_3 != null) {
                    try {
                        life.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    life.close();
                }
            }
        }
    }

    @Test
    public void shouldUpdateCountsOnExistingStore() throws Exception {
        CountsOracle oracle = this.someData();
        int firstTx = 2;
        int secondTx = 3;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker tracker = (CountsTracker)life.add((Lifecycle)this.newTracker());
            oracle.update(tracker, firstTx);
            tracker.rotate((long)firstTx);
            oracle.verify(tracker);
            CountsOracle delta = new CountsOracle();
            CountsOracle.Node n1 = delta.node(1L);
            CountsOracle.Node n2 = delta.node(1L, 4L);
            delta.relationship(n1, 1, n2);
            delta.relationship(n2, 2, n1);
            delta.update(tracker, secondTx);
            delta.update(oracle);
            oracle.verify(tracker);
            tracker.rotate((long)secondTx);
        }
        life = new Lifespan(new Lifecycle[0]);
        var5_5 = null;
        try {
            oracle.verify((CountsVisitor.Visitable)life.add((Lifecycle)this.newTracker()));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (life != null) {
                if (var5_5 != null) {
                    try {
                        life.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    life.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToReadUpToDateValueWhileAnotherThreadIsPerformingRotation() throws Exception {
        CountsOracle oracle = this.someData();
        int firstTransaction = 2;
        int secondTransaction = 3;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker tracker = (CountsTracker)life.add((Lifecycle)this.newTracker());
            oracle.update(tracker, 2L);
            tracker.rotate(2L);
        }
        CountsOracle delta = new CountsOracle();
        CountsOracle.Node n1 = delta.node(1L);
        CountsOracle.Node n2 = delta.node(1L, 4L);
        delta.relationship(n1, 1, n2);
        delta.relationship(n2, 2, n1);
        delta.update(oracle);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            final Barrier.Control barrier = new Barrier.Control();
            CountsTracker tracker = (CountsTracker)life.add((Lifecycle)new CountsTracker(this.resourceManager.logProvider(), this.resourceManager.fileSystem(), this.resourceManager.pageCache(), Config.empty(), this.resourceManager.testPath()){

                protected boolean include(CountsKey countsKey, ReadableBuffer value) {
                    barrier.reached();
                    return super.include(countsKey, value);
                }
            });
            Future task = this.threading.execute(t -> {
                try {
                    delta.update((CountsTracker)t, 3L);
                    t.rotate(3L);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                return null;
            }, tracker);
            barrier.await();
            oracle.verify(tracker);
            barrier.release();
            task.get();
            oracle.verify(tracker);
        }
    }

    @Test
    public void shouldOrderStoreByTxIdInHeaderThenMinorVersion() throws Exception {
        FileVersion version = new FileVersion(16L, 5L);
        Assert.assertTrue((CountsTracker.compare((FileVersion)version, (FileVersion)new FileVersion(5L, 5L)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((CountsTracker.compare((FileVersion)version, (FileVersion)new FileVersion(16L, 5L)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((CountsTracker.compare((FileVersion)version, (FileVersion)new FileVersion(30L, 1L)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CountsTracker.compare((FileVersion)version, (FileVersion)new FileVersion(16L, 1L)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((CountsTracker.compare((FileVersion)version, (FileVersion)new FileVersion(16L, 7L)) < 0 ? 1 : 0) != 0);
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldNotRotateIfNoDataChanges() throws Exception {
        CountsTracker tracker = this.resourceManager.managed(this.newTracker());
        File before = tracker.currentFile();
        tracker.rotate(tracker.txId());
        Assert.assertSame((String)"not rotated", (Object)before, (Object)tracker.currentFile());
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldRotateOnDataChangesEvenIfTransactionIsUnchanged() throws Exception {
        CountsTracker tracker = this.resourceManager.managed(this.newTracker());
        File before = tracker.currentFile();
        try (CountsAccessor.IndexStatsUpdater updater = tracker.updateIndexCounts();){
            updater.incrementIndexUpdates(7, 8, 100L);
        }
        tracker.rotate(tracker.txId());
        Assert.assertNotEquals((String)"rotated", (Object)before, (Object)tracker.currentFile());
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldSupportTransactionsAppliedOutOfOrderOnRotation() throws Exception {
        CountsTracker tracker = this.resourceManager.managed(this.newTracker());
        try (CountsAccessor.Updater tx = (CountsAccessor.Updater)tracker.apply(2L).get();){
            tx.incrementNodeCount(1, 1L);
        }
        tx = (CountsAccessor.Updater)tracker.apply(4L).get();
        var3_3 = null;
        try {
            tx.incrementNodeCount(1, 1L);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Future rotated = this.threading.executeAndAwait(new Rotation(2L), tracker, thread -> {
            switch (thread.getState()) {
                case BLOCKED: 
                case WAITING: 
                case TIMED_WAITING: 
                case TERMINATED: {
                    return true;
                }
            }
            return false;
        }, 10L, TimeUnit.SECONDS);
        try (CountsAccessor.Updater tx = (CountsAccessor.Updater)tracker.apply(5L).get();){
            tx.incrementNodeCount(1, 1L);
        }
        tx = (CountsAccessor.Updater)tracker.apply(3L).get();
        var4_8 = null;
        try {
            tx.incrementNodeCount(1, 1L);
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((String)"rotated transaction", (long)4L, (long)((Long)rotated.get()));
        Assert.assertEquals((String)"stored transaction", (long)4L, (long)tracker.txId());
        Assert.assertEquals((String)"count", (long)4L, (long)tracker.nodeCount(1, Registers.newDoubleLongRegister()).readSecond());
        CountsVisitor visitor = (CountsVisitor)Mockito.mock(CountsVisitor.class);
        tracker.visitFile(tracker.currentFile(), visitor);
        ((CountsVisitor)Mockito.verify((Object)visitor)).visitNodeCount(1, 3L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
        Assert.assertEquals((String)"final rotation", (long)5L, (long)tracker.rotate(5L));
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldNotEndUpInBrokenStateAfterRotationFailure() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        CountsTracker tracker = this.resourceManager.managed(this.newTracker((Clock)clock));
        int labelId = 1;
        try (CountsAccessor.Updater tx = (CountsAccessor.Updater)tracker.apply(2L).get();){
            tx.incrementNodeCount(labelId, 1L);
        }
        Predicate<Thread> arrived = thread -> DebugUtil.stackTraceContains((Thread)thread, (Predicate)Predicates.all((Predicate[])new Predicate[]{DebugUtil.classNameContains((String)"Rotation"), DebugUtil.methodIs((String)"rotate")}));
        Future rotation = this.threading.executeAndAwait(t -> t.rotate(4L), tracker, arrived, 100L, TimeUnit.MILLISECONDS);
        try (CountsAccessor.Updater tx = (CountsAccessor.Updater)tracker.apply(3L).get();){
            tx.incrementNodeCount(labelId, 1L);
        }
        clock.forward((Long)Config.empty().get(GraphDatabaseSettings.counts_store_rotation_timeout) * 2L, TimeUnit.MILLISECONDS);
        try {
            rotation.get();
            Assert.fail((String)"Should've failed rotation due to timeout");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RotationTimeoutException));
        }
        Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
        tracker.get((CountsKey)CountsKeyFactory.nodeKey((int)labelId), register);
        Assert.assertEquals((long)2L, (long)register.readSecond());
        try (CountsAccessor.Updater tx = (CountsAccessor.Updater)tracker.apply(4L).get();){
            tx.incrementNodeCount(labelId, 1L);
        }
        tracker.rotate(4L);
        tracker.get((CountsKey)CountsKeyFactory.nodeKey((int)labelId), register);
        Assert.assertEquals((long)3L, (long)register.readSecond());
    }

    private CountsTracker newTracker() {
        return this.newTracker(Clocks.systemClock());
    }

    private CountsTracker newTracker(Clock clock) {
        return new CountsTracker(this.resourceManager.logProvider(), this.resourceManager.fileSystem(), this.resourceManager.pageCache(), Config.empty(), this.resourceManager.testPath(), clock).setInitializer((DataInitializer)new DataInitializer<CountsAccessor.Updater>(){

            public void initialize(CountsAccessor.Updater updater) {
            }

            public long initialVersion() {
                return 1L;
            }
        });
    }

    private CountsOracle someData() {
        CountsOracle oracle = new CountsOracle();
        CountsOracle.Node n0 = oracle.node(0L, 1L);
        CountsOracle.Node n1 = oracle.node(0L, 3L);
        CountsOracle.Node n2 = oracle.node(2L, 3L);
        CountsOracle.Node n3 = oracle.node(2L);
        oracle.relationship(n0, 1, n2);
        oracle.relationship(n1, 1, n3);
        oracle.relationship(n1, 1, n2);
        oracle.relationship(n0, 1, n3);
        oracle.indexUpdatesAndSize(1, 2, 0L, 50L);
        oracle.indexSampling(1, 2, 25L, 50L);
        return oracle;
    }

    private static class Rotation
    implements IOFunction<CountsTracker, Long> {
        private final long txId;

        Rotation(long txId) {
            this.txId = txId;
        }

        public Long apply(CountsTracker tracker) throws IOException {
            return tracker.rotate(this.txId);
        }
    }
}

