/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.monitoring;

import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;

public class VisibleMigrationProgressMonitorTest {
    @Test
    public void shouldReportAllPercentageSteps() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log);
        monitor.started();
        this.monitorSection(monitor, "First", 100, 40, 25, 23, 10, 50);
        monitor.completed();
        this.verifySectionReportedCorrectly(logProvider);
    }

    @Test
    public void progressNeverReportMoreThenHundredPercent() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log);
        monitor.started();
        this.monitorSection(monitor, "First", 100, 1, 10, 99, 170);
        monitor.completed();
        this.verifySectionReportedCorrectly(logProvider);
    }

    private void verifySectionReportedCorrectly(AssertableLogProvider logProvider) {
        logProvider.assertContainsMessageContaining("Starting upgrade of database");
        for (int i = 10; i <= 100; i += 10) {
            logProvider.assertContainsMessageContaining(String.valueOf(i) + "%");
        }
        logProvider.assertNone(AssertableLogProvider.inLog(VisibleMigrationProgressMonitor.class).info(Matchers.containsString((String)"110%")));
        logProvider.assertContainsMessageContaining("Successfully finished upgrade of database");
    }

    private void monitorSection(VisibleMigrationProgressMonitor monitor, String name, int max, int ... steps) {
        MigrationProgressMonitor.Section section = monitor.startSection(name);
        section.start((long)max);
        for (int step : steps) {
            section.progress((long)step);
        }
        section.completed();
    }
}

