/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;

public class SchemaIndexMigratorTest {
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final MigrationProgressMonitor.Section progressMonitor = (MigrationProgressMonitor.Section)Mockito.mock(MigrationProgressMonitor.Section.class);
    private final SchemaIndexProvider schemaIndexProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
    private final LabelScanStoreProvider labelScanStoreProvider = (LabelScanStoreProvider)Mockito.mock(LabelScanStoreProvider.class);
    private final File storeDir = new File("store");
    private final File migrationDir = new File("migrationDir");
    private final SchemaIndexMigrator migrator = new SchemaIndexMigrator(this.fs, this.schemaIndexProvider, this.labelScanStoreProvider);

    @Test
    public void schemaAndLabelIndexesRemovedAfterSuccessfulMigration() throws IOException {
        Mockito.when((Object)this.schemaIndexProvider.getProviderDescriptor()).thenReturn((Object)new SchemaIndexProvider.Descriptor("key", "version"));
        this.migrator.migrate(this.storeDir, this.migrationDir, this.progressMonitor, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
        this.migrator.moveMigratedFiles(this.migrationDir, this.storeDir, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(this.schemaIndexProvider.getSchemaIndexStoreDirectory(this.storeDir));
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(LabelScanStoreProvider.getStoreDirectory((File)this.storeDir));
    }
}

