/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;

public class SimpleBitSetTest {
    @Test
    public void put() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        set.put(2);
        set.put(7);
        set.put(15);
        TestCase.assertFalse((boolean)set.contains(1));
        TestCase.assertFalse((boolean)set.contains(6));
        TestCase.assertFalse((boolean)set.contains(14));
        junit.framework.Assert.assertTrue((boolean)set.contains(2));
        junit.framework.Assert.assertTrue((boolean)set.contains(7));
        junit.framework.Assert.assertTrue((boolean)set.contains(15));
    }

    @Test
    public void putAndRemove() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        set.put(2);
        set.put(7);
        set.remove(2);
        TestCase.assertFalse((boolean)set.contains(1));
        TestCase.assertFalse((boolean)set.contains(6));
        TestCase.assertFalse((boolean)set.contains(14));
        TestCase.assertFalse((boolean)set.contains(2));
        junit.framework.Assert.assertTrue((boolean)set.contains(7));
    }

    @Test
    public void putOtherBitSet() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        SimpleBitSet otherSet = new SimpleBitSet(16);
        otherSet.put(4);
        otherSet.put(14);
        set.put(3);
        set.put(4);
        set.put(otherSet);
        TestCase.assertFalse((boolean)set.contains(0));
        TestCase.assertFalse((boolean)set.contains(1));
        TestCase.assertFalse((boolean)set.contains(15));
        TestCase.assertFalse((boolean)set.contains(7));
        junit.framework.Assert.assertTrue((boolean)set.contains(3));
        junit.framework.Assert.assertTrue((boolean)set.contains(4));
        junit.framework.Assert.assertTrue((boolean)set.contains(14));
    }

    @Test
    public void removeOtherBitSet() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        SimpleBitSet otherSet = new SimpleBitSet(16);
        otherSet.put(4);
        otherSet.put(12);
        otherSet.put(14);
        set.put(3);
        set.put(4);
        set.put(12);
        set.remove(otherSet);
        TestCase.assertFalse((boolean)set.contains(0));
        TestCase.assertFalse((boolean)set.contains(1));
        TestCase.assertFalse((boolean)set.contains(4));
        TestCase.assertFalse((boolean)set.contains(14));
        junit.framework.Assert.assertTrue((boolean)set.contains(3));
    }

    @Test
    public void resize() throws Exception {
        SimpleBitSet set = new SimpleBitSet(8);
        set.put(128);
        junit.framework.Assert.assertTrue((boolean)set.contains(128));
        TestCase.assertFalse((boolean)set.contains(126));
        TestCase.assertFalse((boolean)set.contains(129));
    }

    @Test
    public void shouldAllowIterating() throws Exception {
        SimpleBitSet set = new SimpleBitSet(64);
        set.put(4);
        set.put(7);
        set.put(63);
        set.put(78);
        List found = PrimitiveIntCollections.toList((PrimitiveIntIterator)set.iterator());
        Assert.assertThat((Object)found, (Matcher)Matchers.equalTo(Arrays.asList(4, 7, 63, 78)));
    }

    @Test
    public void checkPointOnUnchangedSetMustDoNothing() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        int key = 10;
        set.put(key);
        long checkpoint = 0L;
        checkpoint = set.checkPointAndPut(checkpoint, key);
        Assert.assertThat((Object)set.checkPointAndPut(checkpoint, key), (Matcher)Matchers.is((Object)checkpoint));
        junit.framework.Assert.assertTrue((boolean)set.contains(key));
    }

    @Test
    public void checkPointOnUnchangedSetButWithDifferentKeyMustUpdateSet() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        int key = 10;
        set.put(key);
        long checkpoint = 0L;
        checkpoint = set.checkPointAndPut(checkpoint, key);
        Assert.assertThat((Object)set.checkPointAndPut(checkpoint, key + 1), (Matcher)Matchers.is((Matcher)Matchers.not((Object)checkpoint)));
        junit.framework.Assert.assertTrue((boolean)set.contains(key + 1));
        TestCase.assertFalse((boolean)set.contains(key));
    }

    @Test
    public void checkPointOnChangedSetMustClearState() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        int key = 10;
        set.put(key);
        long checkpoint = 0L;
        checkpoint = set.checkPointAndPut(checkpoint, key);
        set.put(key + 1);
        Assert.assertThat((Object)set.checkPointAndPut(checkpoint, key), (Matcher)Matchers.is((Matcher)Matchers.not((Object)checkpoint)));
        junit.framework.Assert.assertTrue((boolean)set.contains(key));
        TestCase.assertFalse((boolean)set.contains(key + 1));
    }

    @Test
    public void checkPointMustBeAbleToExpandCapacity() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        int key = 10;
        int key2 = 255;
        set.put(key);
        long checkpoint = 0L;
        checkpoint = set.checkPointAndPut(checkpoint, key);
        Assert.assertThat((Object)set.checkPointAndPut(checkpoint, key2), (Matcher)Matchers.is((Matcher)Matchers.not((Object)checkpoint)));
        junit.framework.Assert.assertTrue((boolean)set.contains(key2));
        TestCase.assertFalse((boolean)set.contains(key));
    }

    @Test
    public void modificationsMustTakeWriteLocks() throws Exception {
        SimpleBitSet set = new SimpleBitSet(16);
        long stamp = set.tryOptimisticRead();
        set.put(8);
        TestCase.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        set.put(8);
        TestCase.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        SimpleBitSet other = new SimpleBitSet(16);
        other.put(3);
        set.put(other);
        TestCase.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        set.remove(3);
        TestCase.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        set.remove(3);
        TestCase.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        other.put(8);
        set.remove(other);
        TestCase.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        other.put(8);
        set.remove(other);
        TestCase.assertFalse((boolean)set.validate(stamp));
    }
}

